"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _kibana = require("../../../../../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IntegrationLinkComponent = ({
  integration
}) => {
  const basePath = (0, _kibana.useBasePath)();
  const linkText = integration.integrationTitle;
  const linkUrl = `${basePath}/${integration.targetUrl}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: linkUrl,
    target: "_blank",
    "data-test-subj": 'integrationLink'
  }, linkText);
};

/**
 * Renders an `EuiLink` that will link to a given package/integration/version page within fleet.
 */
const IntegrationLink = /*#__PURE__*/_react.default.memo(IntegrationLinkComponent);
exports.IntegrationLink = IntegrationLink;
IntegrationLink.displayName = 'IntegrationLink';