"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpdatePrePackagedRulesCallOut = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _kibana = require("../../../../common/lib/kibana");
var _use_pre_packaged_rules_status = require("../../../../detection_engine/rule_management/logic/use_pre_packaged_rules_status");
var _load_prepackaged_rules = require("./load_prepackaged_rules");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UpdatePrePackagedRulesCallOutComponent = () => {
  var _prePackagedRulesStat, _prePackagedRulesStat2;
  const {
    services
  } = (0, _kibana.useKibana)();
  const {
    data: prePackagedRulesStatus
  } = (0, _use_pre_packaged_rules_status.usePrePackagedRulesStatus)();
  const rulesNotUpdated = (_prePackagedRulesStat = prePackagedRulesStatus === null || prePackagedRulesStatus === void 0 ? void 0 : prePackagedRulesStatus.rules_not_updated) !== null && _prePackagedRulesStat !== void 0 ? _prePackagedRulesStat : 0;
  const timelinesNotUpdated = (_prePackagedRulesStat2 = prePackagedRulesStatus === null || prePackagedRulesStatus === void 0 ? void 0 : prePackagedRulesStatus.timelines_not_updated) !== null && _prePackagedRulesStat2 !== void 0 ? _prePackagedRulesStat2 : 0;
  const prepackagedRulesOrTimelines = (0, _react.useMemo)(() => {
    if (rulesNotUpdated > 0 && timelinesNotUpdated === 0) {
      return {
        callOutMessage: i18n.UPDATE_PREPACKAGED_RULES_MSG(rulesNotUpdated),
        buttonTitle: i18n.UPDATE_PREPACKAGED_RULES(rulesNotUpdated)
      };
    } else if (rulesNotUpdated === 0 && timelinesNotUpdated > 0) {
      return {
        callOutMessage: i18n.UPDATE_PREPACKAGED_TIMELINES_MSG(timelinesNotUpdated),
        buttonTitle: i18n.UPDATE_PREPACKAGED_TIMELINES(timelinesNotUpdated)
      };
    } else if (rulesNotUpdated > 0 && timelinesNotUpdated > 0) return {
      callOutMessage: i18n.UPDATE_PREPACKAGED_RULES_AND_TIMELINES_MSG(rulesNotUpdated, timelinesNotUpdated),
      buttonTitle: i18n.UPDATE_PREPACKAGED_RULES_AND_TIMELINES(rulesNotUpdated, timelinesNotUpdated)
    };
  }, [rulesNotUpdated, timelinesNotUpdated]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: i18n.UPDATE_PREPACKAGED_RULES_TITLE,
    "data-test-subj": "update-callout"
  }, /*#__PURE__*/_react.default.createElement("p", null, prepackagedRulesOrTimelines === null || prepackagedRulesOrTimelines === void 0 ? void 0 : prepackagedRulesOrTimelines.callOutMessage, /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `${services.docLinks.links.siem.ruleChangeLog}`,
    target: "_blank"
  }, i18n.RELEASE_NOTES_HELP)), /*#__PURE__*/_react.default.createElement(_load_prepackaged_rules.LoadPrePackagedRules, null, renderProps => /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    size: "s",
    "data-test-subj": "update-callout-button"
  }, renderProps), prepackagedRulesOrTimelines === null || prepackagedRulesOrTimelines === void 0 ? void 0 : prepackagedRulesOrTimelines.buttonTitle)));
};
const UpdatePrePackagedRulesCallOut = /*#__PURE__*/(0, _react.memo)(UpdatePrePackagedRulesCallOutComponent);
exports.UpdatePrePackagedRulesCallOut = UpdatePrePackagedRulesCallOut;