"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UPDATE_PREPACKAGED_TIMELINES_MSG = exports.UPDATE_PREPACKAGED_TIMELINES = exports.UPDATE_PREPACKAGED_RULES_TITLE = exports.UPDATE_PREPACKAGED_RULES_MSG = exports.UPDATE_PREPACKAGED_RULES_AND_TIMELINES_MSG = exports.UPDATE_PREPACKAGED_RULES_AND_TIMELINES = exports.UPDATE_PREPACKAGED_RULES = exports.RELOAD_MISSING_PREPACKAGED_TIMELINES = exports.RELOAD_MISSING_PREPACKAGED_RULES_AND_TIMELINES = exports.RELOAD_MISSING_PREPACKAGED_RULES = exports.RELEASE_NOTES_HELP = exports.PRE_BUILT_TITLE = exports.PRE_BUILT_MSG = exports.LOAD_PREPACKAGED_TIMELINE_TEMPLATES = exports.LOAD_PREPACKAGED_RULES_AND_TEMPLATES = exports.LOAD_PREPACKAGED_RULES = exports.CREATE_RULE_ACTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PRE_BUILT_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.prePackagedRules.emptyPromptTitle', {
  defaultMessage: 'Load Elastic prebuilt detection rules'
});
exports.PRE_BUILT_TITLE = PRE_BUILT_TITLE;
const PRE_BUILT_MSG = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.prePackagedRules.emptyPromptMessage', {
  defaultMessage: 'Elastic Security comes with prebuilt detection rules that run in the background and create alerts when their conditions are met. By default, all prebuilt rules except the Endpoint Security rule are disabled. You can select additional rules you want to enable.'
});
exports.PRE_BUILT_MSG = PRE_BUILT_MSG;
const CREATE_RULE_ACTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.prePackagedRules.createOwnRuletButton', {
  defaultMessage: 'Create your own rules'
});
exports.CREATE_RULE_ACTION = CREATE_RULE_ACTION;
const UPDATE_PREPACKAGED_RULES_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.updatePrePackagedRulesTitle', {
  defaultMessage: 'Update available for Elastic prebuilt rules or timeline templates'
});
exports.UPDATE_PREPACKAGED_RULES_TITLE = UPDATE_PREPACKAGED_RULES_TITLE;
const UPDATE_PREPACKAGED_RULES_MSG = updateRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.updatePrePackagedRulesMsg', {
  values: {
    updateRules
  },
  defaultMessage: 'You can update {updateRules} Elastic prebuilt {updateRules, plural, =1 {rule} other {rules}}'
});
exports.UPDATE_PREPACKAGED_RULES_MSG = UPDATE_PREPACKAGED_RULES_MSG;
const UPDATE_PREPACKAGED_TIMELINES_MSG = updateTimelines => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.updatePrePackagedTimelinesMsg', {
  values: {
    updateTimelines
  },
  defaultMessage: 'You can update {updateTimelines} Elastic prebuilt {updateTimelines, plural, =1 {timeline} other {timelines}}'
});
exports.UPDATE_PREPACKAGED_TIMELINES_MSG = UPDATE_PREPACKAGED_TIMELINES_MSG;
const UPDATE_PREPACKAGED_RULES_AND_TIMELINES_MSG = (updateRules, updateTimelines) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.updatePrePackagedRulesAndTimelinesMsg', {
  values: {
    updateRules,
    updateTimelines
  },
  defaultMessage: 'You can update {updateRules} Elastic prebuilt {updateRules, plural, =1 {rule} other {rules}} and {updateTimelines} Elastic prebuilt {updateTimelines, plural, =1 {timeline} other {timelines}}. Note that this will reload deleted Elastic prebuilt rules.'
});
exports.UPDATE_PREPACKAGED_RULES_AND_TIMELINES_MSG = UPDATE_PREPACKAGED_RULES_AND_TIMELINES_MSG;
const UPDATE_PREPACKAGED_RULES = updateRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.updatePrePackagedRulesButton', {
  values: {
    updateRules
  },
  defaultMessage: 'Update {updateRules} Elastic prebuilt {updateRules, plural, =1 {rule} other {rules}}'
});
exports.UPDATE_PREPACKAGED_RULES = UPDATE_PREPACKAGED_RULES;
const UPDATE_PREPACKAGED_TIMELINES = updateTimelines => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.updatePrePackagedTimelinesButton', {
  values: {
    updateTimelines
  },
  defaultMessage: 'Update {updateTimelines} Elastic prebuilt {updateTimelines, plural, =1 {timeline} other {timelines}}'
});
exports.UPDATE_PREPACKAGED_TIMELINES = UPDATE_PREPACKAGED_TIMELINES;
const UPDATE_PREPACKAGED_RULES_AND_TIMELINES = (updateRules, updateTimelines) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.updatePrePackagedRulesAndTimelinesButton', {
  values: {
    updateRules,
    updateTimelines
  },
  defaultMessage: 'Update {updateRules} Elastic prebuilt {updateRules, plural, =1 {rule} other {rules}} and {updateTimelines} Elastic prebuilt {updateTimelines, plural, =1 {timeline} other {timelines}}'
});
exports.UPDATE_PREPACKAGED_RULES_AND_TIMELINES = UPDATE_PREPACKAGED_RULES_AND_TIMELINES;
const RELEASE_NOTES_HELP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.releaseNotesHelp', {
  defaultMessage: 'Release notes'
});
exports.RELEASE_NOTES_HELP = RELEASE_NOTES_HELP;
const LOAD_PREPACKAGED_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.loadPrePackagedRulesButton', {
  defaultMessage: 'Load Elastic prebuilt rules'
});
exports.LOAD_PREPACKAGED_RULES = LOAD_PREPACKAGED_RULES;
const LOAD_PREPACKAGED_TIMELINE_TEMPLATES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.loadPrePackagedTimelineTemplatesButton', {
  defaultMessage: 'Load Elastic prebuilt timeline templates'
});
exports.LOAD_PREPACKAGED_TIMELINE_TEMPLATES = LOAD_PREPACKAGED_TIMELINE_TEMPLATES;
const LOAD_PREPACKAGED_RULES_AND_TEMPLATES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.loadPrePackagedRulesAndTemplatesButton', {
  defaultMessage: 'Load Elastic prebuilt rules and timeline templates'
});
exports.LOAD_PREPACKAGED_RULES_AND_TEMPLATES = LOAD_PREPACKAGED_RULES_AND_TEMPLATES;
const RELOAD_MISSING_PREPACKAGED_RULES = missingRules => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.reloadMissingPrePackagedRulesButton', {
  values: {
    missingRules
  },
  defaultMessage: 'Install {missingRules} Elastic prebuilt {missingRules, plural, =1 {rule} other {rules}} '
});
exports.RELOAD_MISSING_PREPACKAGED_RULES = RELOAD_MISSING_PREPACKAGED_RULES;
const RELOAD_MISSING_PREPACKAGED_TIMELINES = missingTimelines => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.reloadMissingPrePackagedTimelinesButton', {
  values: {
    missingTimelines
  },
  defaultMessage: 'Install {missingTimelines} Elastic prebuilt {missingTimelines, plural, =1 {timeline} other {timelines}} '
});
exports.RELOAD_MISSING_PREPACKAGED_TIMELINES = RELOAD_MISSING_PREPACKAGED_TIMELINES;
const RELOAD_MISSING_PREPACKAGED_RULES_AND_TIMELINES = (missingRules, missingTimelines) => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.reloadMissingPrePackagedRulesAndTimelinesButton', {
  values: {
    missingRules,
    missingTimelines
  },
  defaultMessage: 'Install {missingRules} Elastic prebuilt {missingRules, plural, =1 {rule} other {rules}} and {missingTimelines} Elastic prebuilt {missingTimelines, plural, =1 {timeline} other {timelines}} '
});
exports.RELOAD_MISSING_PREPACKAGED_RULES_AND_TIMELINES = RELOAD_MISSING_PREPACKAGED_RULES_AND_TIMELINES;