"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadPrePackagedRulesButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_pre_packaged_rules_installation_status = require("../../../../detection_engine/rule_management/logic/use_pre_packaged_rules_installation_status");
var _use_pre_packaged_rules_status = require("../../../../detection_engine/rule_management/logic/use_pre_packaged_rules_status");
var _use_pre_packaged_timelines_installation_status = require("../../../../detection_engine/rule_management/logic/use_pre_packaged_timelines_installation_status");
var _rules_management_tour = require("../../../../detection_engine/rule_management_ui/components/rules_table/rules_table/guided_onboarding/rules_management_tour");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLoadRulesOrTimelinesButtonTitle = (rulesStatus, timelineStatus) => {
  if (rulesStatus === 'ruleNotInstalled' && timelineStatus === 'timelinesNotInstalled') return i18n.LOAD_PREPACKAGED_RULES_AND_TEMPLATES;else if (rulesStatus === 'ruleNotInstalled' && timelineStatus !== 'timelinesNotInstalled') return i18n.LOAD_PREPACKAGED_RULES;else if (rulesStatus !== 'ruleNotInstalled' && timelineStatus === 'timelinesNotInstalled') return i18n.LOAD_PREPACKAGED_TIMELINE_TEMPLATES;
};
const getMissingRulesOrTimelinesButtonTitle = (missingRules, missingTimelines) => {
  if (missingRules > 0 && missingTimelines === 0) return i18n.RELOAD_MISSING_PREPACKAGED_RULES(missingRules);else if (missingRules === 0 && missingTimelines > 0) return i18n.RELOAD_MISSING_PREPACKAGED_TIMELINES(missingTimelines);else if (missingRules > 0 && missingTimelines > 0) return i18n.RELOAD_MISSING_PREPACKAGED_RULES_AND_TIMELINES(missingRules, missingTimelines);
};
const LoadPrePackagedRulesButton = ({
  fill,
  'data-test-subj': dataTestSubj = 'loadPrebuiltRulesBtn',
  isLoading,
  isDisabled,
  onClick
}) => {
  const {
    data: prePackagedRulesStatus
  } = (0, _use_pre_packaged_rules_status.usePrePackagedRulesStatus)();
  const prePackagedAssetsStatus = (0, _use_pre_packaged_rules_installation_status.usePrePackagedRulesInstallationStatus)();
  const prePackagedTimelineStatus = (0, _use_pre_packaged_timelines_installation_status.usePrePackagedTimelinesInstallationStatus)();
  const showInstallButton = (prePackagedAssetsStatus === 'ruleNotInstalled' || prePackagedTimelineStatus === 'timelinesNotInstalled') && prePackagedAssetsStatus !== 'someRuleUninstall';
  if (showInstallButton) {
    // Without the outer div EuiStepTour crashes with Uncaught DOMException:
    // Failed to execute 'removeChild' on 'Node': The node to be removed is not
    // a child of this node.
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      id: _rules_management_tour.INSTALL_PREBUILT_RULES_ANCHOR,
      fill: fill,
      iconType: "indexOpen",
      isLoading: isLoading,
      isDisabled: isDisabled,
      onClick: onClick,
      "data-test-subj": dataTestSubj
    }, getLoadRulesOrTimelinesButtonTitle(prePackagedAssetsStatus, prePackagedTimelineStatus)));
  }
  const showUpdateButton = prePackagedAssetsStatus === 'someRuleUninstall' || prePackagedTimelineStatus === 'someTimelineUninstall';
  if (showUpdateButton) {
    var _prePackagedRulesStat, _prePackagedRulesStat2;
    // Without the outer div EuiStepTour crashes with Uncaught DOMException:
    // Failed to execute 'removeChild' on 'Node': The node to be removed is not
    // a child of this node.
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      id: _rules_management_tour.INSTALL_PREBUILT_RULES_ANCHOR,
      fill: fill,
      iconType: "plusInCircle",
      isLoading: isLoading,
      isDisabled: isDisabled,
      onClick: onClick,
      "data-test-subj": dataTestSubj
    }, getMissingRulesOrTimelinesButtonTitle((_prePackagedRulesStat = prePackagedRulesStatus === null || prePackagedRulesStatus === void 0 ? void 0 : prePackagedRulesStatus.rules_not_installed) !== null && _prePackagedRulesStat !== void 0 ? _prePackagedRulesStat : 0, (_prePackagedRulesStat2 = prePackagedRulesStatus === null || prePackagedRulesStatus === void 0 ? void 0 : prePackagedRulesStatus.timelines_not_installed) !== null && _prePackagedRulesStat2 !== void 0 ? _prePackagedRulesStat2 : 0)));
  }
  return null;
};
exports.LoadPrePackagedRulesButton = LoadPrePackagedRulesButton;