"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadPrePackagedRules = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_installed_security_jobs = require("../../../../common/components/ml/hooks/use_installed_security_jobs");
var _use_bool_state = require("../../../../common/hooks/use_bool_state");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _use_create_pre_packaged_rules = require("../../../../detection_engine/rule_management/logic/use_create_pre_packaged_rules");
var _use_install_pre_packaged_rules = require("../../../../detection_engine/rule_management/logic/use_install_pre_packaged_rules");
var _use_pre_packaged_rules_status = require("../../../../detection_engine/rule_management/logic/use_pre_packaged_rules_status");
var _affected_job_ids = require("../../callouts/ml_job_compatibility_callout/affected_job_ids");
var _ml_job_upgrade_modal = require("../../modals/ml_job_upgrade_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LoadPrePackagedRules = ({
  children
}) => {
  const {
    isFetching: isFetchingPrepackagedStatus
  } = (0, _use_pre_packaged_rules_status.usePrePackagedRulesStatus)();
  const isInstallingPrebuiltRules = (0, _use_install_pre_packaged_rules.useIsInstallingPrePackagedRules)();
  const {
    createPrePackagedRules,
    canCreatePrePackagedRules
  } = (0, _use_create_pre_packaged_rules.useCreatePrePackagedRules)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const handleCreatePrePackagedRules = (0, _react.useCallback)(async () => {
    startTransaction({
      name: _user_actions.RULES_TABLE_ACTIONS.LOAD_PREBUILT
    });
    await createPrePackagedRules();
  }, [createPrePackagedRules, startTransaction]);
  const [isUpgradeModalVisible, showUpgradeModal, hideUpgradeModal] = (0, _use_bool_state.useBoolState)(false);
  const {
    loading: loadingJobs,
    jobs
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobs)();
  const legacyJobsInstalled = jobs.filter(job => _affected_job_ids.affectedJobIds.includes(job.id));
  const handleInstallPrePackagedRules = (0, _react.useCallback)(async () => {
    if (legacyJobsInstalled.length > 0) {
      showUpgradeModal();
    } else {
      await handleCreatePrePackagedRules();
    }
  }, [handleCreatePrePackagedRules, legacyJobsInstalled.length, showUpgradeModal]);

  // Wrapper to add confirmation modal for users who may be running older ML Jobs that would
  // be overridden by updating their rules. For details, see: https://github.com/elastic/kibana/issues/128121
  const mlJobUpgradeModalConfirm = (0, _react.useCallback)(() => {
    hideUpgradeModal();
    handleCreatePrePackagedRules();
  }, [handleCreatePrePackagedRules, hideUpgradeModal]);
  const isDisabled = !canCreatePrePackagedRules || isFetchingPrepackagedStatus || loadingJobs;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children({
    isLoading: isInstallingPrebuiltRules,
    isDisabled,
    onClick: handleInstallPrePackagedRules
  }), isUpgradeModalVisible && /*#__PURE__*/_react.default.createElement(_ml_job_upgrade_modal.MlJobUpgradeModal, {
    jobs: legacyJobsInstalled,
    onCancel: () => hideUpgradeModal(),
    onConfirm: mlJobUpgradeModalConfirm
  }));
};
exports.LoadPrePackagedRules = LoadPrePackagedRules;