"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrePackagedRulesPrompt = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _types = require("../../../../app/types");
var _links = require("../../../../common/components/links");
var _privileges = require("../../../../common/utils/privileges");
var _user_info = require("../../user_info");
var _load_prepackaged_rules = require("./load_prepackaged_rules");
var _load_prepackaged_rules_button = require("./load_prepackaged_rules_button");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyPrompt = (0, _styledComponents.default)(_eui.EuiEmptyPrompt)`
  align-self: center; /* Corrects horizontal centering in IE11 */
`;
EmptyPrompt.displayName = 'EmptyPrompt';
const PrePackagedRulesPromptComponent = () => {
  const [{
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const hasPermissions = (0, _privileges.hasUserCRUDPermission)(canUserCRUD);
  return /*#__PURE__*/_react.default.createElement(EmptyPrompt, {
    "data-test-subj": "rulesEmptyPrompt",
    title: /*#__PURE__*/_react.default.createElement("h2", null, i18n.PRE_BUILT_TITLE),
    body: /*#__PURE__*/_react.default.createElement("p", null, i18n.PRE_BUILT_MSG),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_load_prepackaged_rules.LoadPrePackagedRules, null, renderProps => /*#__PURE__*/_react.default.createElement(_load_prepackaged_rules_button.LoadPrePackagedRulesButton, (0, _extends2.default)({
      fill: true,
      "data-test-subj": "load-prebuilt-rules"
    }, renderProps)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkButton, {
      isDisabled: !hasPermissions,
      iconType: "plusInCircle",
      deepLinkId: _types.SecurityPageName.rulesCreate
    }, i18n.CREATE_RULE_ACTION)))
  });
};
const PrePackagedRulesPrompt = /*#__PURE__*/(0, _react.memo)(PrePackagedRulesPromptComponent);
exports.PrePackagedRulesPrompt = PrePackagedRulesPrompt;