"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlJobsDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _has_ml_admin_permissions = require("../../../../../common/machine_learning/has_ml_admin_permissions");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _ml_admin_jobs_description = require("./admin/ml_admin_jobs_description");
var _ml_user_jobs_description = require("./user/ml_user_jobs_description");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MlJobsDescriptionComponent = ({
  jobIds
}) => {
  const mlCapabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const isMlUser = (0, _has_ml_user_permissions.hasMlUserPermissions)(mlCapabilities);
  const isMlAdmin = (0, _has_ml_admin_permissions.hasMlAdminPermissions)(mlCapabilities);
  if (isMlAdmin) {
    return /*#__PURE__*/_react.default.createElement(_ml_admin_jobs_description.MlAdminJobsDescription, {
      jobIds: jobIds
    });
  }
  if (isMlUser) {
    return /*#__PURE__*/_react.default.createElement(_ml_user_jobs_description.MlUserJobsDescription, {
      jobIds: jobIds
    });
  }
  return null;
};
const MlJobsDescription = /*#__PURE__*/(0, _react.memo)(MlJobsDescriptionComponent);
exports.MlJobsDescription = MlJobsDescription;