"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EqlQueryBarFooter = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
var _errors_popover = require("./errors_popover");
var _eql_overview_link = require("./eql_overview_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Container = (0, _styledComponents.default)(_eui.EuiPanel)`
  border-radius: 0;
  background: ${({
  theme
}) => theme.eui.euiPageBackgroundColor};
  padding: ${({
  theme
}) => theme.eui.euiSizeXS} ${({
  theme
}) => theme.eui.euiSizeS};
`;
const FlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  min-height: ${({
  theme
}) => theme.eui.euiSizeXL};
`;
const FlexItemLeftBorder = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  border-left: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
`;
const FlexItemWithMarginRight = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-right: ${({
  theme
}) => theme.eui.euiSizeS};
`;
const Spinner = (0, _styledComponents.default)(_eui.EuiLoadingSpinner)`
  margin: 0 ${({
  theme
}) => theme.eui.euiSizeS};
`;
const singleSelection = {
  asPlainText: true
};
const EqlQueryBarFooter = ({
  errors,
  isLoading,
  isSizeOptionDisabled,
  optionsData,
  optionsSelected,
  onOptionsChange
}) => {
  var _optionsSelected$size;
  const [openEqlSettings, setIsOpenEqlSettings] = (0, _react.useState)(false);
  const [localSize, setLocalSize] = (0, _react.useState)((_optionsSelected$size = optionsSelected === null || optionsSelected === void 0 ? void 0 : optionsSelected.size) !== null && _optionsSelected$size !== void 0 ? _optionsSelected$size : 100);
  const debounceSize = (0, _react.useRef)();
  const openEqlSettingsHandler = (0, _react.useCallback)(() => {
    setIsOpenEqlSettings(true);
  }, []);
  const closeEqlSettingsHandler = (0, _react.useCallback)(() => {
    setIsOpenEqlSettings(false);
  }, []);
  const handleEventCategoryField = (0, _react.useCallback)(opt => {
    if (onOptionsChange) {
      if (opt.length > 0) {
        onOptionsChange('eventCategoryField', opt[0].label);
      } else {
        onOptionsChange('eventCategoryField', undefined);
      }
    }
  }, [onOptionsChange]);
  const handleTiebreakerField = (0, _react.useCallback)(opt => {
    if (onOptionsChange) {
      if (opt.length > 0) {
        onOptionsChange('tiebreakerField', opt[0].label);
      } else {
        onOptionsChange('tiebreakerField', undefined);
      }
    }
  }, [onOptionsChange]);
  const handleTimestampField = (0, _react.useCallback)(opt => {
    if (onOptionsChange) {
      if (opt.length > 0) {
        onOptionsChange('timestampField', opt[0].label);
      } else {
        onOptionsChange('timestampField', undefined);
      }
    }
  }, [onOptionsChange]);
  const handleSizeField = (0, _react.useCallback)(evt => {
    if (onOptionsChange) {
      var _evt$target, _debounceSize$current, _evt$target2;
      setLocalSize(evt === null || evt === void 0 ? void 0 : (_evt$target = evt.target) === null || _evt$target === void 0 ? void 0 : _evt$target.value);
      if ((_debounceSize$current = debounceSize.current) !== null && _debounceSize$current !== void 0 && _debounceSize$current.cancel) {
        var _debounceSize$current2;
        (_debounceSize$current2 = debounceSize.current) === null || _debounceSize$current2 === void 0 ? void 0 : _debounceSize$current2.cancel();
      }
      debounceSize.current = (0, _lodash.debounce)(newSize => onOptionsChange('size', newSize), 800);
      debounceSize.current(evt === null || evt === void 0 ? void 0 : (_evt$target2 = evt.target) === null || _evt$target2 === void 0 ? void 0 : _evt$target2.value);
    }
  }, [onOptionsChange]);
  const eventCategoryField = (0, _react.useMemo)(() => (optionsSelected === null || optionsSelected === void 0 ? void 0 : optionsSelected.eventCategoryField) != null ? [{
    label: optionsSelected === null || optionsSelected === void 0 ? void 0 : optionsSelected.eventCategoryField
  }] : undefined, [optionsSelected === null || optionsSelected === void 0 ? void 0 : optionsSelected.eventCategoryField]);
  const tiebreakerField = (0, _react.useMemo)(() => (optionsSelected === null || optionsSelected === void 0 ? void 0 : optionsSelected.tiebreakerField) != null ? [{
    label: optionsSelected === null || optionsSelected === void 0 ? void 0 : optionsSelected.tiebreakerField
  }] : undefined, [optionsSelected === null || optionsSelected === void 0 ? void 0 : optionsSelected.tiebreakerField]);
  const timestampField = (0, _react.useMemo)(() => (optionsSelected === null || optionsSelected === void 0 ? void 0 : optionsSelected.timestampField) != null ? [{
    label: optionsSelected === null || optionsSelected === void 0 ? void 0 : optionsSelected.timestampField
  }] : undefined, [optionsSelected === null || optionsSelected === void 0 ? void 0 : optionsSelected.timestampField]);
  return /*#__PURE__*/_react.default.createElement(Container, null, /*#__PURE__*/_react.default.createElement(FlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, errors.length > 0 && /*#__PURE__*/_react.default.createElement(_errors_popover.ErrorsPopover, {
    ariaLabel: i18n.EQL_VALIDATION_ERROR_POPOVER_LABEL,
    errors: errors
  }), isLoading && /*#__PURE__*/_react.default.createElement(Spinner, {
    "data-test-subj": "eql-validation-loading",
    size: "m"
  })), !onOptionsChange && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eql_overview_link.EqlOverviewLink, null)), onOptionsChange && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlexItemWithMarginRight, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eql_overview_link.EqlOverviewLink, null)), /*#__PURE__*/_react.default.createElement(FlexItemLeftBorder, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: openEqlSettingsHandler,
      iconType: "controlsVertical",
      isDisabled: openEqlSettings,
      "aria-label": "eql settings",
      "data-test-subj": "eql-settings-trigger"
    }),
    isOpen: openEqlSettings,
    closePopover: closeEqlSettingsHandler,
    anchorPosition: "downCenter",
    ownFocus: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, i18n.EQL_SETTINGS_TITLE), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    }
  }, !isSizeOptionDisabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "eql-size-field",
    label: i18n.EQL_OPTIONS_SIZE_LABEL,
    helpText: i18n.EQL_OPTIONS_SIZE_HELPER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    value: localSize,
    onChange: handleSizeField,
    min: 1,
    max: 10000
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "eql-event-category-field",
    label: i18n.EQL_OPTIONS_EVENT_CATEGORY_FIELD_LABEL,
    helpText: i18n.EQL_OPTIONS_EVENT_CATEGORY_FIELD_HELPER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: optionsData === null || optionsData === void 0 ? void 0 : optionsData.keywordFields,
    selectedOptions: eventCategoryField,
    singleSelection: singleSelection,
    onChange: handleEventCategoryField
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "eql-tiebreaker-field",
    label: i18n.EQL_OPTIONS_EVENT_TIEBREAKER_FIELD_LABEL,
    helpText: i18n.EQL_OPTIONS_EVENT_TIEBREAKER_FIELD_HELPER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: optionsData === null || optionsData === void 0 ? void 0 : optionsData.nonDateFields,
    selectedOptions: tiebreakerField,
    singleSelection: singleSelection,
    onChange: handleTiebreakerField
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "eql-timestamp-field",
    label: i18n.EQL_OPTIONS_EVENT_TIMESTAMP_FIELD_LABEL,
    helpText: i18n.EQL_OPTIONS_EVENT_TIMESTAMP_FIELD_HELPER
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: optionsData === null || optionsData === void 0 ? void 0 : optionsData.dateFields,
    selectedOptions: timestampField,
    singleSelection: singleSelection,
    onChange: handleTimestampField
  }))))))));
};
exports.EqlQueryBarFooter = EqlQueryBarFooter;