"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorsPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorsPopover = ({
  ariaLabel,
  errors
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const handleToggle = (0, _react.useCallback)(() => {
    setIsOpen(!isOpen);
  }, [isOpen]);
  const handleClose = (0, _react.useCallback)(() => {
    setIsOpen(false);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "eql-validation-errors-popover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "eql-validation-errors-popover-button",
      iconType: "error",
      size: "s",
      color: "danger",
      "aria-label": ariaLabel,
      onClick: handleToggle
    }, errors.length),
    isOpen: isOpen,
    closePopover: handleClose,
    anchorPosition: "downCenter"
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "eql-validation-errors-popover-content"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, i18n.EQL_VALIDATION_ERRORS_TITLE), errors.map((message, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    key: idx
  }, message))));
};
exports.ErrorsPopover = ErrorsPopover;