"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatEuiFlexGroup = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _list_tree_icon = _interopRequireDefault(require("./assets/list_tree_icon.svg"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const lazyMitreConfiguration = () => {
  /**
   * The specially formatted comment in the `import` expression causes the corresponding webpack chunk to be named. This aids us in debugging chunk size issues.
   * See https://webpack.js.org/api/module-methods/#magic-comments
   */
  return Promise.resolve().then(() => _interopRequireWildcard(require( /* webpackChunkName: "lazy_mitre_configuration" */
  '../../../mitre/mitre_tactics_techniques')));
};
const ThreatEuiFlexGroupStyles = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  .euiFlexItem {
    margin-bottom: 0px;
  }
`;
const SubtechniqueFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin-left: ${({
  theme
}) => theme.eui.euiSizeM};
`;
const TechniqueLinkItem = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  .euiIcon {
    width: 8px;
    height: 8px;
  }
  align-self: flex-start;
`;
const ThreatEuiFlexGroup = ({
  label,
  threat
}) => {
  const [techniquesOptions, setTechniquesOptions] = (0, _react.useState)([]);
  const [tacticsOptions, setTacticsOptions] = (0, _react.useState)([]);
  const [subtechniquesOptions, setSubtechniquesOptions] = (0, _react.useState)([]);
  (0, _react.useEffect)(() => {
    async function getMitre() {
      const mitreConfig = await lazyMitreConfiguration();
      setSubtechniquesOptions(mitreConfig.subtechniquesOptions);
      setTechniquesOptions(mitreConfig.techniquesOptions);
      setTacticsOptions(mitreConfig.tacticsOptions);
    }
    getMitre();
  }, []);
  return /*#__PURE__*/_react.default.createElement(ThreatEuiFlexGroupStyles, {
    direction: "column"
  }, threat.map((singleThreat, index) => {
    const tactic = tacticsOptions.find(t => t.id === singleThreat.tactic.id);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${singleThreat.tactic.name}-${index}`
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-test-subj": "threatTacticLink",
      href: singleThreat.tactic.reference,
      target: "_blank"
    }, tactic != null ? tactic.text : `${singleThreat.tactic.name} (${singleThreat.tactic.id})`), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      alignItems: "flexStart",
      direction: "column"
    }, singleThreat.technique && singleThreat.technique.map((technique, techniqueIndex) => {
      var _myTechnique$id;
      const myTechnique = techniquesOptions.find(t => t.id === technique.id);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: (_myTechnique$id = myTechnique === null || myTechnique === void 0 ? void 0 : myTechnique.id) !== null && _myTechnique$id !== void 0 ? _myTechnique$id : techniqueIndex
      }, /*#__PURE__*/_react.default.createElement(TechniqueLinkItem, {
        "data-test-subj": "threatTechniqueLink",
        href: technique.reference,
        target: "_blank",
        iconType: _list_tree_icon.default,
        size: "xs"
      }, myTechnique != null ? myTechnique.label : `${technique.name} (${technique.id})`), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "none",
        alignItems: "flexStart",
        direction: "column"
      }, technique.subtechnique != null && technique.subtechnique.map((subtechnique, subtechniqueIndex) => {
        var _mySubtechnique$id;
        const mySubtechnique = subtechniquesOptions.find(t => t.id === subtechnique.id);
        return /*#__PURE__*/_react.default.createElement(SubtechniqueFlexItem, {
          key: (_mySubtechnique$id = mySubtechnique === null || mySubtechnique === void 0 ? void 0 : mySubtechnique.id) !== null && _mySubtechnique$id !== void 0 ? _mySubtechnique$id : subtechniqueIndex
        }, /*#__PURE__*/_react.default.createElement(TechniqueLinkItem, {
          "data-test-subj": "threatSubtechniqueLink",
          href: subtechnique.reference,
          target: "_blank",
          iconType: _list_tree_icon.default,
          size: "xs"
        }, mySubtechnique != null ? mySubtechnique.label : `${subtechnique.name} (${subtechnique.id})`));
      })));
    })));
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null));
};
exports.ThreatEuiFlexGroup = ThreatEuiFlexGroup;