"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isNotEmptyArray = exports.buildUrlsDescription = exports.buildUnorderedListArrayDescription = exports.buildThresholdDescription = exports.buildThreatMappingDescription = exports.buildThreatDescription = exports.buildStringArrayDescription = exports.buildSeverityDescription = exports.buildRuleTypeDescription = exports.buildRiskScoreDescription = exports.buildRequiredFieldsDescription = exports.buildQueryBarDescription = exports.buildNoteDescription = exports.buildEqlOptionsDescription = exports.buildAlertSuppressionWindowDescription = exports.buildAlertSuppressionMissingFieldsDescription = exports.buildAlertSuppressionDescription = void 0;
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _fieldTypes = require("@kbn/field-types");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactField = require("@kbn/react-field");
var _public = require("@kbn/unified-search-plugin/public");
var _translations = require("../../../../common/components/threat_match/translations");
var _utility_types = require("../../../../../common/utility_types");
var i18nSeverity = _interopRequireWildcard(require("../severity_mapping/translations"));
var i18nRiskScore = _interopRequireWildcard(require("../risk_score_mapping/translations"));
var i18n = _interopRequireWildcard(require("./translations"));
var _severity_badge = require("../severity_badge");
var _types = require("../../../pages/detection_engine/rules/types");
var _empty_value = require("../../../../common/components/empty_value");
var _threat_description = require("./threat_description");
var _technical_preview_badge = require("./technical_preview_badge");
var _rule_schema = require("../../../../../common/detection_engine/rule_schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoteDescriptionContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  height: 105px;
  overflow-y: hidden;
`;
const isNotEmptyArray = values => !(0, _fp.isEmpty)(values.join(''));
exports.isNotEmptyArray = isNotEmptyArray;
const EuiBadgeWrap = (0, _styledComponents.default)(_eui.EuiBadge)`
  .euiBadge__text {
    white-space: pre-wrap !important;
  }
`;
const Query = _styledComponents.default.div`
  white-space: pre-wrap;
`;
const buildQueryBarDescription = ({
  field,
  filters,
  filterManager,
  query,
  savedId,
  savedQueryName,
  indexPatterns,
  queryLabel
}) => {
  let items = [];
  const isLoadedFromSavedQuery = !(0, _fp.isEmpty)(savedId) && !(0, _fp.isEmpty)(savedQueryName);
  if (isLoadedFromSavedQuery) {
    items = [...items, {
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.SAVED_QUERY_NAME_LABEL, " "),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, savedQueryName, " ")
    }];
  }
  if (!(0, _fp.isEmpty)(filters)) {
    filterManager.setFilters(filters);
    items = [...items, {
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoadedFromSavedQuery ? i18n.SAVED_QUERY_FILTERS_LABEL : i18n.FILTERS_LABEL, " "),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        wrap: true,
        responsive: false,
        gutterSize: "xs"
      }, filterManager.getFilters().map((filter, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: `${field}-filter-${index}`,
        css: {
          width: '100%'
        }
      }, /*#__PURE__*/_react.default.createElement(EuiBadgeWrap, {
        color: "hollow"
      }, indexPatterns != null ? /*#__PURE__*/_react.default.createElement(_public.FilterBadgeGroup, {
        filters: [filter],
        dataViews: [indexPatterns]
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      })))))
    }];
  }
  if (!(0, _fp.isEmpty)(query)) {
    items = [...items, {
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoadedFromSavedQuery ? i18n.SAVED_QUERY_LABEL : queryLabel !== null && queryLabel !== void 0 ? queryLabel : i18n.QUERY_LABEL),
      description: /*#__PURE__*/_react.default.createElement(Query, null, query)
    }];
  }
  return items;
};
exports.buildQueryBarDescription = buildQueryBarDescription;
const buildEqlOptionsDescription = eqlOptions => {
  let items = [];
  if (!(0, _fp.isEmpty)(eqlOptions.eventCategoryField)) {
    items = [...items, {
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.EQL_EVENT_CATEGORY_FIELD_LABEL),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, eqlOptions.eventCategoryField)
    }];
  }
  if (!(0, _fp.isEmpty)(eqlOptions.tiebreakerField)) {
    items = [...items, {
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.EQL_TIEBREAKER_FIELD_LABEL),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, eqlOptions.tiebreakerField)
    }];
  }
  if (!(0, _fp.isEmpty)(eqlOptions.timestampField)) {
    items = [...items, {
      title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.EQL_TIMESTAMP_FIELD_LABEL),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, eqlOptions.timestampField)
    }];
  }
  return items;
};
exports.buildEqlOptionsDescription = buildEqlOptionsDescription;
const buildThreatDescription = ({
  label,
  threat
}) => {
  if (threat.length > 0) {
    return [{
      title: label,
      description: /*#__PURE__*/_react.default.createElement(_threat_description.ThreatEuiFlexGroup, {
        label: label,
        threat: threat
      })
    }];
  }
  return [];
};
exports.buildThreatDescription = buildThreatDescription;
const buildUnorderedListArrayDescription = (label, field, values) => {
  if (isNotEmptyArray(values)) {
    return [{
      title: label,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("ul", null, values.map(val => (0, _fp.isEmpty)(val) ? null : /*#__PURE__*/_react.default.createElement("li", {
        "data-test-subj": "unorderedListArrayDescriptionItem",
        key: `${field}-${val}`
      }, val))))
    }];
  }
  return [];
};
exports.buildUnorderedListArrayDescription = buildUnorderedListArrayDescription;
const buildStringArrayDescription = (label, field, values) => {
  if (isNotEmptyArray(values)) {
    return [{
      title: label,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        responsive: false,
        gutterSize: "xs",
        wrap: true
      }, values.map(val => (0, _fp.isEmpty)(val) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        key: `${field}-${val}`
      }, /*#__PURE__*/_react.default.createElement(EuiBadgeWrap, {
        "data-test-subj": "stringArrayDescriptionBadgeItem",
        color: "hollow"
      }, val))))
    }];
  }
  return [];
};
exports.buildStringArrayDescription = buildStringArrayDescription;
const OverrideColumn = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  width: 125px;
  max-width: 125px;
  overflow: hidden;
  text-overflow: ellipsis;
`;
const buildSeverityDescription = severity => [{
  title: i18nSeverity.DEFAULT_SEVERITY,
  description: /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
    value: severity.value
  })
}, ...(severity.isMappingChecked ? severity.mapping.filter(severityItem => severityItem.field !== '').map((severityItem, index) => {
  return {
    title: index === 0 ? i18nSeverity.SEVERITY_MAPPING : '',
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(OverrideColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: severityItem.field,
      "data-test-subj": `severityOverrideField${index}`
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${severityItem.field}:`))), /*#__PURE__*/_react.default.createElement(OverrideColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: severityItem.value,
      "data-test-subj": `severityOverrideValue${index}`
    }, (0, _empty_value.defaultToEmptyTag)(severityItem.value))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'sortRight'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_severity_badge.SeverityBadge, {
      "data-test-subj": `severityOverrideSeverity${index}`,
      value: severityItem.severity
    })))
  };
}) : [])];
exports.buildSeverityDescription = buildSeverityDescription;
const buildRiskScoreDescription = riskScore => [{
  title: i18nRiskScore.RISK_SCORE,
  description: riskScore.value
}, ...(riskScore.isMappingChecked ? riskScore.mapping.filter(riskScoreItem => riskScoreItem.field !== '').map((riskScoreItem, index) => {
  return {
    title: index === 0 ? i18nRiskScore.RISK_SCORE_MAPPING : '',
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(OverrideColumn, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: riskScoreItem.field,
      "data-test-subj": `riskScoreOverrideField${index}`
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, riskScoreItem.field))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: 'sortRight'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _ruleDataUtils.ALERT_RISK_SCORE))
  };
}) : [])];
exports.buildRiskScoreDescription = buildRiskScoreDescription;
const MyRefUrlLink = (0, _styledComponents.default)(_eui.EuiLink)`
  word-break: break-word;
`;
const buildUrlsDescription = (label, values) => {
  if (isNotEmptyArray(values)) {
    return [{
      title: label,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("ul", null, values.filter(v => !(0, _fp.isEmpty)(v)).map((val, index) => /*#__PURE__*/_react.default.createElement("li", {
        "data-test-subj": "urlsDescriptionReferenceLinkItem",
        key: `${index}-${val}`
      }, /*#__PURE__*/_react.default.createElement(MyRefUrlLink, {
        href: val,
        external: true,
        target: "_blank"
      }, val)))))
    }];
  }
  return [];
};
exports.buildUrlsDescription = buildUrlsDescription;
const buildNoteDescription = (label, note) => {
  if (note.trim() !== '') {
    return [{
      title: label,
      description: /*#__PURE__*/_react.default.createElement(NoteDescriptionContainer, null, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "noteDescriptionItem",
        className: "eui-yScrollWithShadows"
      }, note))
    }];
  }
  return [];
};
exports.buildNoteDescription = buildNoteDescription;
const buildRuleTypeDescription = (label, ruleType) => {
  switch (ruleType) {
    case 'machine_learning':
      {
        return [{
          title: label,
          description: i18n.ML_TYPE_DESCRIPTION
        }];
      }
    case 'query':
    case 'saved_query':
      {
        return [{
          title: label,
          description: i18n.QUERY_TYPE_DESCRIPTION
        }];
      }
    case 'threshold':
      {
        return [{
          title: label,
          description: i18n.THRESHOLD_TYPE_DESCRIPTION
        }];
      }
    case 'eql':
      {
        return [{
          title: label,
          description: i18n.EQL_TYPE_DESCRIPTION
        }];
      }
    case 'threat_match':
      {
        return [{
          title: label,
          description: i18n.THREAT_MATCH_TYPE_DESCRIPTION
        }];
      }
    case 'new_terms':
      {
        return [{
          title: label,
          description: i18n.NEW_TERMS_TYPE_DESCRIPTION
        }];
      }
    default:
      return (0, _utility_types.assertUnreachable)(ruleType);
  }
};
exports.buildRuleTypeDescription = buildRuleTypeDescription;
const buildThresholdDescription = (label, threshold) => [{
  title: label,
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (0, _fp.isEmpty)(threshold.field[0]) ? `${i18n.THRESHOLD_RESULTS_ALL} >= ${threshold.value}` : `${i18n.THRESHOLD_RESULTS_AGGREGATED_BY} ${Array.isArray(threshold.field) ? threshold.field.join(',') : threshold.field} >= ${threshold.value}`)
}];
exports.buildThresholdDescription = buildThresholdDescription;
const buildThreatMappingDescription = (title, threatMapping) => {
  const description = threatMapping.reduce((accumThreatMaps, threatMap, threatMapIndex, {
    length: threatMappingLength
  }) => {
    const matches = threatMap.entries.reduce((accumItems, item, itemsIndex, {
      length: threatMapLength
    }) => {
      if (threatMapLength === 1) {
        return `${item.field} ${_translations.MATCHES} ${item.value}`;
      } else if (itemsIndex === 0) {
        return `(${item.field} ${_translations.MATCHES} ${item.value})`;
      } else {
        return `${accumItems} ${_translations.AND} (${item.field} ${_translations.MATCHES} ${item.value})`;
      }
    }, '');
    if (threatMappingLength === 1) {
      return `${matches}`;
    } else if (threatMapIndex === 0) {
      return `(${matches})`;
    } else {
      return `${accumThreatMaps} ${_translations.OR} (${matches})`;
    }
  }, '');
  return [{
    title,
    description
  }];
};
exports.buildThreatMappingDescription = buildThreatMappingDescription;
const FieldTypeText = (0, _styledComponents.default)(_eui.EuiText)`
  font-size: ${({
  theme
}) => theme.eui.euiFontSizeXS};
  font-family: ${({
  theme
}) => theme.eui.euiCodeFontFamily};
  display: inline;
`;
const buildRequiredFieldsDescription = (label, requiredFields) => {
  if ((0, _fp.isEmpty)(requiredFields)) {
    return [];
  }
  return [{
    title: label,
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
      gutterSize: 's'
    }, requiredFields.map((rF, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: 'xs'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
      "data-test-subj": "field-type-icon",
      type: (0, _fieldTypes.castEsToKbnFieldTypeName)(rF.type),
      label: rF.type
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(FieldTypeText, {
      grow: false,
      size: 's'
    }, ` ${rF.name}${index + 1 !== requiredFields.length ? ', ' : ''}`))))))
  }];
};
exports.buildRequiredFieldsDescription = buildRequiredFieldsDescription;
const buildAlertSuppressionDescription = (label, values, license) => {
  if ((0, _fp.isEmpty)(values)) {
    return [];
  }
  const description = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    wrap: true
  }, values.map(val => (0, _fp.isEmpty)(val) ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: `${label}-${val}`
  }, /*#__PURE__*/_react.default.createElement(EuiBadgeWrap, {
    "data-test-subj": "stringArrayDescriptionBadgeItem",
    color: "hollow"
  }, val))));
  const title = /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    label: label,
    license: license
  });
  return [{
    title,
    description
  }];
};
exports.buildAlertSuppressionDescription = buildAlertSuppressionDescription;
const buildAlertSuppressionWindowDescription = (label, value, license, groupByRadioSelection) => {
  const description = groupByRadioSelection === _types.GroupByOptions.PerTimePeriod ? `${value.value}${value.unit}` : i18n.ALERT_SUPPRESSION_PER_RULE_EXECUTION;
  const title = /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    label: label,
    license: license
  });
  return [{
    title,
    description
  }];
};
exports.buildAlertSuppressionWindowDescription = buildAlertSuppressionWindowDescription;
const buildAlertSuppressionMissingFieldsDescription = (label, value, license) => {
  if ((0, _fp.isEmpty)(value)) {
    return [];
  }
  const description = value === _rule_schema.AlertSuppressionMissingFieldsStrategy.Suppress ? i18n.ALERT_SUPPRESSION_SUPPRESS_ON_MISSING_FIELDS : i18n.ALERT_SUPPRESSION_DO_NOT_SUPPRESS_ON_MISSING_FIELDS;
  const title = /*#__PURE__*/_react.default.createElement(_technical_preview_badge.TechnicalPreviewBadge, {
    label: label,
    license: license
  });
  return [{
    title,
    description
  }];
};
exports.buildAlertSuppressionMissingFieldsDescription = buildAlertSuppressionMissingFieldsDescription;