"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResponderActionItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _user_privileges = require("../../../common/components/user_privileges");
var _endpoint_alert_check = require("../../../common/utils/endpoint_alert_check");
var _responder_context_menu_item = require("./responder_context_menu_item");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _helpers = require("../host_isolation/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useResponderActionItem = (eventDetailsData, onClick) => {
  const isResponseActionsConsoleEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsConsoleEnabled');
  const {
    loading: isAuthzLoading,
    canAccessResponseConsole
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const isAlert = (0, _react.useMemo)(() => {
    return (0, _endpoint_alert_check.isTimelineEventItemAnAlert)(eventDetailsData || []);
  }, [eventDetailsData]);
  const isEndpointAlert = (0, _react.useMemo)(() => {
    return (0, _endpoint_alert_check.isAlertFromEndpointEvent)({
      data: eventDetailsData || []
    });
  }, [eventDetailsData]);
  const endpointId = (0, _react.useMemo)(() => (0, _helpers.getFieldValue)({
    category: 'agent',
    field: 'agent.id'
  }, eventDetailsData), [eventDetailsData]);
  return (0, _react.useMemo)(() => {
    const actions = [];
    if (isResponseActionsConsoleEnabled && !isAuthzLoading && canAccessResponseConsole && isAlert) {
      actions.push( /*#__PURE__*/_react.default.createElement(_responder_context_menu_item.ResponderContextMenuItem, {
        key: "endpointResponseActions-action-item",
        endpointId: isEndpointAlert ? endpointId : '',
        onClick: onClick
      }));
    }
    return actions;
  }, [canAccessResponseConsole, endpointId, isAlert, isAuthzLoading, isEndpointAlert, isResponseActionsConsoleEnabled, onClick]);
};
exports.useResponderActionItem = useResponderActionItem;