"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResponderActionData = void 0;
var _react = require("react");
var _hooks = require("../../../management/hooks");
var _types = require("../../../../common/endpoint/types");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useResponderActionData = ({
  endpointId,
  onClick
}) => {
  const showEndpointResponseActionsConsole = (0, _hooks.useWithShowEndpointResponder)();
  const {
    data: endpointHostInfo,
    isFetching,
    error
  } = (0, _hooks.useGetEndpointDetails)(endpointId, {
    enabled: Boolean(endpointId)
  });
  const [isDisabled, tooltip] = (0, _react.useMemo)(() => {
    var _error$body, _error$body2;
    if (!endpointId) {
      return [true, _translations.NOT_FROM_ENDPOINT_HOST_TOOLTIP];
    }

    // Still loading Endpoint host info
    if (isFetching) {
      return [true, _translations.LOADING_ENDPOINT_DATA_TOOLTIP];
    }

    // if we got an error and it's a 400 with unenrolled in the error message (alerts can exist for endpoint that are no longer around)
    // or,
    // the Host status is `unenrolled`
    if (error && ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.statusCode) === 400 && (_error$body2 = error.body) !== null && _error$body2 !== void 0 && _error$body2.message.includes('unenrolled') || (endpointHostInfo === null || endpointHostInfo === void 0 ? void 0 : endpointHostInfo.host_status) === _types.HostStatus.UNENROLLED) {
      return [true, _translations.HOST_ENDPOINT_UNENROLLED_TOOLTIP];
    }

    // return general error tooltip
    if (error) {
      return [true, _translations.METADATA_API_ERROR_TOOLTIP];
    }
    return [false, undefined];
  }, [endpointHostInfo, endpointId, error, isFetching]);
  const handleResponseActionsClick = (0, _react.useCallback)(() => {
    if (endpointHostInfo) showEndpointResponseActionsConsole(endpointHostInfo.metadata);
    if (onClick) onClick();
  }, [endpointHostInfo, onClick, showEndpointResponseActionsConsole]);
  return {
    handleResponseActionsClick,
    isDisabled,
    tooltip
  };
};
exports.useResponderActionData = useResponderActionData;