"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponderContextMenuItem = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _use_responder_action_data = require("./use_responder_action_data");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponderContextMenuItem = /*#__PURE__*/(0, _react.memo)(({
  endpointId,
  onClick
}) => {
  const {
    handleResponseActionsClick,
    isDisabled,
    tooltip
  } = (0, _use_responder_action_data.useResponderActionData)({
    endpointId,
    onClick
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "endpointResponseActions-action-item",
    "data-test-subj": "endpointResponseActions-action-item",
    disabled: isDisabled,
    toolTipContent: tooltip,
    size: "s",
    onClick: handleResponseActionsClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.detections.takeAction.responseActionConsole.buttonLabel",
    defaultMessage: "Respond"
  }));
});
exports.ResponderContextMenuItem = ResponderContextMenuItem;
ResponderContextMenuItem.displayName = 'ResponderContextMenuItem';