"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetectionPageFilterSet = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _model = require("../../../common/store/sourcerer/model");
var _loading = require("../../../common/components/filter_group/loading");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/constants");
var _filter_group = require("../../../common/components/filter_group");
var _sourcerer = require("../../../common/containers/sourcerer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SECURITY_ALERT_DATA_VIEW = {
  id: 'security_solution_alerts_dv',
  name: 'Security Solution Alerts DataView'
};
const FilterItemSetComponent = props => {
  const {
    onFilterChange,
    ...restFilterItemGroupProps
  } = props;
  const {
    indexPattern: {
      title
    },
    dataViewId
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
  const [loadingPageFilters, setLoadingPageFilters] = (0, _react.useState)(true);
  const {
    services: {
      dataViews: dataViewService
    }
  } = (0, _kibana.useKibana)();
  (0, _react.useEffect)(() => {
    (async () => {
      // creates an adhoc dataview if it does not already exists just for alert index
      const {
        timeFieldName = '@timestamp'
      } = await dataViewService.get(dataViewId !== null && dataViewId !== void 0 ? dataViewId : '');
      await dataViewService.create({
        id: SECURITY_ALERT_DATA_VIEW.id,
        name: SECURITY_ALERT_DATA_VIEW.name,
        title,
        allowNoIndex: true,
        timeFieldName
      });
      setLoadingPageFilters(false);
    })();
    return () => dataViewService.clearInstanceCache();
  }, [title, dataViewService, dataViewId]);
  const [initialFilterControls] = (0, _react.useState)(_constants.DEFAULT_DETECTION_PAGE_FILTERS);
  const filterChangesHandler = (0, _react.useCallback)(newFilters => {
    if (!onFilterChange) {
      return;
    }
    const updatedFilters = newFilters.map(filter => {
      return {
        ...filter,
        meta: {
          ...filter.meta,
          disabled: false
        }
      };
    });
    onFilterChange(updatedFilters);
  }, [onFilterChange]);
  if (loadingPageFilters) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_loading.FilterGroupLoading, null));
  }
  return /*#__PURE__*/_react.default.createElement(_filter_group.FilterGroup, (0, _extends2.default)({
    dataViewId: SECURITY_ALERT_DATA_VIEW.id,
    onFilterChange: filterChangesHandler,
    initialControls: initialFilterControls
  }, restFilterItemGroupProps));
};
const arePropsEqual = (prevProps, newProps) => {
  const _isEqual = (0, _lodash.isEqual)(prevProps, newProps);
  return _isEqual;
};
const DetectionPageFilterSet = /*#__PURE__*/_react.default.memo(FilterItemSetComponent, arePropsEqual);
exports.DetectionPageFilterSet = DetectionPageFilterSet;