"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userName = exports.sourceIP = exports.sourceAddress = exports.ruleName = exports.hostName = exports.destinationAddress = exports.TRIGGERED = exports.TOTAL_COUNT_OF_ALERTS = exports.TAKE_ACTION = exports.STATUS = exports.STATS_GROUP_USERS = exports.STATS_GROUP_SEVERITY_MULTI = exports.STATS_GROUP_SEVERITY_MEDIUM = exports.STATS_GROUP_SEVERITY_LOW = exports.STATS_GROUP_SEVERITY_HIGH = exports.STATS_GROUP_SEVERITY_CRITICAL = exports.STATS_GROUP_SEVERITY = exports.STATS_GROUP_RULES = exports.STATS_GROUP_IPS = exports.STATS_GROUP_HOSTS = exports.STATS_GROUP_ALERTS = exports.SIGNAL_STATUS = exports.SESSIONS_TITLE = exports.PAGE_TITLE = exports.OPEN_ALERTS = exports.OPENED_ALERT_SUCCESS_TOAST = exports.OPENED_ALERT_FAILED_TOAST = exports.MORE_ACTIONS = exports.LOADING_ALERTS = exports.INVESTIGATE_BULK_IN_TIMELINE = exports.INSPECT_GROUPING_TITLE = exports.GROUP_ALERTS_SELECTOR = exports.EVENT_RENDERED_VIEW_COLUMNS = exports.CLOSED_ALERT_SUCCESS_TOAST = exports.CLOSED_ALERT_FAILED_TOAST = exports.CLOSED_ALERTS = exports.CLICK_TO_CHANGE_ALERT_STATUS = exports.CHANGE_ALERT_STATUS = exports.ALERT_DURATION = exports.ALERTS_HEADERS_THRESHOLD_TERMS = exports.ALERTS_HEADERS_THRESHOLD_COUNT = exports.ALERTS_HEADERS_THRESHOLD_CARDINALITY = exports.ALERTS_HEADERS_SEVERITY = exports.ALERTS_HEADERS_RULE_NAME = exports.ALERTS_HEADERS_RULE_DESCRIPTION = exports.ALERTS_HEADERS_RULE = exports.ALERTS_HEADERS_RISK_SCORE = exports.ALERTS_HEADERS_REASON = exports.ALERTS_HEADERS_NEW_TERMS_FIELDS = exports.ALERTS_HEADERS_NEW_TERMS = exports.ALERTS_DOCUMENT_TYPE = exports.ADD_TO_NEW_CASE = exports.ADD_TO_EXISTING_CASE = exports.ACTION_INVESTIGATE_IN_TIMELINE_ARIA_LABEL = exports.ACTION_INVESTIGATE_IN_TIMELINE = exports.ACTION_ADD_EXCEPTION = exports.ACTION_ADD_EVENT_FILTER_DISABLED_TOOLTIP = exports.ACTION_ADD_EVENT_FILTER = exports.ACTION_ADD_ENDPOINT_EXCEPTION = exports.ACKNOWLEDGED_ALERT_SUCCESS_TOAST = exports.ACKNOWLEDGED_ALERT_FAILED_TOAST = exports.ACKNOWLEDGED_ALERTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PAGE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.pageTitle', {
  defaultMessage: 'Detection engine'
});
exports.PAGE_TITLE = PAGE_TITLE;
const ALERTS_DOCUMENT_TYPE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.documentTypeTitle', {
  defaultMessage: 'Alerts'
});
exports.ALERTS_DOCUMENT_TYPE = ALERTS_DOCUMENT_TYPE;
const OPEN_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.openAlertsTitle', {
  defaultMessage: 'Open'
});
exports.OPEN_ALERTS = OPEN_ALERTS;
const CLOSED_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.closedAlertsTitle', {
  defaultMessage: 'Closed'
});
exports.CLOSED_ALERTS = CLOSED_ALERTS;
const ACKNOWLEDGED_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.acknowledgedAlertsTitle', {
  defaultMessage: 'Acknowledged'
});
exports.ACKNOWLEDGED_ALERTS = ACKNOWLEDGED_ALERTS;
const LOADING_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.loadingAlertsTitle', {
  defaultMessage: 'Loading Alerts'
});
exports.LOADING_ALERTS = LOADING_ALERTS;
const TOTAL_COUNT_OF_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.totalCountOfAlertsTitle', {
  defaultMessage: 'alerts'
});
exports.TOTAL_COUNT_OF_ALERTS = TOTAL_COUNT_OF_ALERTS;
const ALERTS_HEADERS_RULE = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.ruleTitle', {
  defaultMessage: 'Rule'
});
exports.ALERTS_HEADERS_RULE = ALERTS_HEADERS_RULE;
const ALERTS_HEADERS_RULE_NAME = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.ruleNameTitle', {
  defaultMessage: 'Rule name'
});
exports.ALERTS_HEADERS_RULE_NAME = ALERTS_HEADERS_RULE_NAME;
const ALERTS_HEADERS_RULE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.ruleDescriptionTitle', {
  defaultMessage: 'Rule description'
});
exports.ALERTS_HEADERS_RULE_DESCRIPTION = ALERTS_HEADERS_RULE_DESCRIPTION;
const ALERTS_HEADERS_SEVERITY = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.severityTitle', {
  defaultMessage: 'Severity'
});
exports.ALERTS_HEADERS_SEVERITY = ALERTS_HEADERS_SEVERITY;
const ALERTS_HEADERS_REASON = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.reasonTitle', {
  defaultMessage: 'Reason'
});
exports.ALERTS_HEADERS_REASON = ALERTS_HEADERS_REASON;
const ALERTS_HEADERS_RISK_SCORE = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.riskScoreTitle', {
  defaultMessage: 'Risk Score'
});
exports.ALERTS_HEADERS_RISK_SCORE = ALERTS_HEADERS_RISK_SCORE;
const ALERTS_HEADERS_THRESHOLD_COUNT = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.thresholdCount', {
  defaultMessage: 'Event Count'
});
exports.ALERTS_HEADERS_THRESHOLD_COUNT = ALERTS_HEADERS_THRESHOLD_COUNT;
const ALERTS_HEADERS_THRESHOLD_TERMS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.thresholdTerms', {
  defaultMessage: 'Threshold Terms'
});
exports.ALERTS_HEADERS_THRESHOLD_TERMS = ALERTS_HEADERS_THRESHOLD_TERMS;
const ALERTS_HEADERS_THRESHOLD_CARDINALITY = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.thresholdCardinality', {
  defaultMessage: 'Event Cardinality'
});
exports.ALERTS_HEADERS_THRESHOLD_CARDINALITY = ALERTS_HEADERS_THRESHOLD_CARDINALITY;
const ALERTS_HEADERS_NEW_TERMS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.newTerms', {
  defaultMessage: 'New Terms'
});
exports.ALERTS_HEADERS_NEW_TERMS = ALERTS_HEADERS_NEW_TERMS;
const ALERTS_HEADERS_NEW_TERMS_FIELDS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.newTermsFields', {
  defaultMessage: 'New Terms fields'
});
exports.ALERTS_HEADERS_NEW_TERMS_FIELDS = ALERTS_HEADERS_NEW_TERMS_FIELDS;
const ACTION_INVESTIGATE_IN_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.investigateInTimelineTitle', {
  defaultMessage: 'Investigate in timeline'
});
exports.ACTION_INVESTIGATE_IN_TIMELINE = ACTION_INVESTIGATE_IN_TIMELINE;
const ACTION_INVESTIGATE_IN_TIMELINE_ARIA_LABEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.investigateInTimelineAriaLabel', {
  defaultMessage: 'Send alert to timeline'
});
exports.ACTION_INVESTIGATE_IN_TIMELINE_ARIA_LABEL = ACTION_INVESTIGATE_IN_TIMELINE_ARIA_LABEL;
const ACTION_ADD_EXCEPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addException', {
  defaultMessage: 'Add rule exception'
});
exports.ACTION_ADD_EXCEPTION = ACTION_ADD_EXCEPTION;
const ACTION_ADD_EVENT_FILTER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addEventFilter', {
  defaultMessage: 'Add Endpoint event filter'
});
exports.ACTION_ADD_EVENT_FILTER = ACTION_ADD_EVENT_FILTER;
const ACTION_ADD_EVENT_FILTER_DISABLED_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addEventFilter.disabled.tooltip', {
  defaultMessage: 'Endpoint event filters can be created from the Events section of the Hosts page.'
});
exports.ACTION_ADD_EVENT_FILTER_DISABLED_TOOLTIP = ACTION_ADD_EVENT_FILTER_DISABLED_TOOLTIP;
const ACTION_ADD_ENDPOINT_EXCEPTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addEndpointException', {
  defaultMessage: 'Add Endpoint exception'
});
exports.ACTION_ADD_ENDPOINT_EXCEPTION = ACTION_ADD_ENDPOINT_EXCEPTION;
const CLOSED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.closedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully closed {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}.'
});
exports.CLOSED_ALERT_SUCCESS_TOAST = CLOSED_ALERT_SUCCESS_TOAST;
const ALERT_DURATION = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.alertDurationTitle', {
  defaultMessage: 'Alert duration'
});
exports.ALERT_DURATION = ALERT_DURATION;
const OPENED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.openedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully opened {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}}.'
});
exports.OPENED_ALERT_SUCCESS_TOAST = OPENED_ALERT_SUCCESS_TOAST;
const ACKNOWLEDGED_ALERT_SUCCESS_TOAST = totalAlerts => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.acknowledgedAlertSuccessToastMessage', {
  values: {
    totalAlerts
  },
  defaultMessage: 'Successfully marked {totalAlerts} {totalAlerts, plural, =1 {alert} other {alerts}} as acknowledged.'
});
exports.ACKNOWLEDGED_ALERT_SUCCESS_TOAST = ACKNOWLEDGED_ALERT_SUCCESS_TOAST;
const CLOSED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.closedAlertFailedToastMessage', {
  defaultMessage: 'Failed to close alert(s).'
});
exports.CLOSED_ALERT_FAILED_TOAST = CLOSED_ALERT_FAILED_TOAST;
const OPENED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.openedAlertFailedToastMessage', {
  defaultMessage: 'Failed to open alert(s)'
});
exports.OPENED_ALERT_FAILED_TOAST = OPENED_ALERT_FAILED_TOAST;
const ACKNOWLEDGED_ALERT_FAILED_TOAST = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.acknowledgedAlertFailedToastMessage', {
  defaultMessage: 'Failed to mark alert(s) as acknowledged'
});
exports.ACKNOWLEDGED_ALERT_FAILED_TOAST = ACKNOWLEDGED_ALERT_FAILED_TOAST;
const MORE_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.moreActionsAriaLabel', {
  defaultMessage: 'More actions'
});
exports.MORE_ACTIONS = MORE_ACTIONS;
const STATUS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.statusTitle', {
  defaultMessage: 'Status'
});
exports.STATUS = STATUS;
const CHANGE_ALERT_STATUS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.overview.changeAlertStatus', {
  defaultMessage: 'Change alert status'
});
exports.CHANGE_ALERT_STATUS = CHANGE_ALERT_STATUS;
const CLICK_TO_CHANGE_ALERT_STATUS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.overview.clickToChangeAlertStatus', {
  defaultMessage: 'Click to change alert status'
});
exports.CLICK_TO_CHANGE_ALERT_STATUS = CLICK_TO_CHANGE_ALERT_STATUS;
const SIGNAL_STATUS = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.overviewTable.signalStatusTitle', {
  defaultMessage: 'Status'
});
exports.SIGNAL_STATUS = SIGNAL_STATUS;
const TRIGGERED = _i18n.i18n.translate('xpack.securitySolution.eventsViewer.alerts.defaultHeaders.triggeredTitle', {
  defaultMessage: 'Triggered'
});
exports.TRIGGERED = TRIGGERED;
const ADD_TO_EXISTING_CASE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addToCase', {
  defaultMessage: 'Add to existing case'
});
exports.ADD_TO_EXISTING_CASE = ADD_TO_EXISTING_CASE;
const ADD_TO_NEW_CASE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addToNewCase', {
  defaultMessage: 'Add to new case'
});
exports.ADD_TO_NEW_CASE = ADD_TO_NEW_CASE;
const INVESTIGATE_BULK_IN_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.addBulkToTimeline', {
  defaultMessage: 'Investigate in timeline'
});
exports.INVESTIGATE_BULK_IN_TIMELINE = INVESTIGATE_BULK_IN_TIMELINE;
const SESSIONS_TITLE = _i18n.i18n.translate('xpack.securitySolution.sessionsView.sessionsTitle', {
  defaultMessage: 'Sessions'
});
exports.SESSIONS_TITLE = SESSIONS_TITLE;
const TAKE_ACTION = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.additionalActions.takeAction', {
  defaultMessage: 'Take actions'
});
exports.TAKE_ACTION = TAKE_ACTION;
const STATS_GROUP_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.alertsCount', {
  defaultMessage: 'Alerts:'
});
exports.STATS_GROUP_ALERTS = STATS_GROUP_ALERTS;
const STATS_GROUP_HOSTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.hostsCount', {
  defaultMessage: 'Hosts:'
});
exports.STATS_GROUP_HOSTS = STATS_GROUP_HOSTS;
const STATS_GROUP_IPS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.ipsCount', {
  defaultMessage: `IP's:`
});
exports.STATS_GROUP_IPS = STATS_GROUP_IPS;
const GROUP_ALERTS_SELECTOR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.selectGroup.title', {
  defaultMessage: `Group alerts by`
});
exports.GROUP_ALERTS_SELECTOR = GROUP_ALERTS_SELECTOR;
const STATS_GROUP_USERS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.usersCount', {
  defaultMessage: 'Users:'
});
exports.STATS_GROUP_USERS = STATS_GROUP_USERS;
const STATS_GROUP_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.rulesCount', {
  defaultMessage: 'Rules:'
});
exports.STATS_GROUP_RULES = STATS_GROUP_RULES;
const STATS_GROUP_SEVERITY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity', {
  defaultMessage: 'Severity:'
});
exports.STATS_GROUP_SEVERITY = STATS_GROUP_SEVERITY;
const STATS_GROUP_SEVERITY_MULTI = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity.multi', {
  defaultMessage: 'Multi'
});
exports.STATS_GROUP_SEVERITY_MULTI = STATS_GROUP_SEVERITY_MULTI;
const STATS_GROUP_SEVERITY_LOW = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity.low', {
  defaultMessage: 'Low'
});
exports.STATS_GROUP_SEVERITY_LOW = STATS_GROUP_SEVERITY_LOW;
const STATS_GROUP_SEVERITY_HIGH = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity.high', {
  defaultMessage: 'High'
});
exports.STATS_GROUP_SEVERITY_HIGH = STATS_GROUP_SEVERITY_HIGH;
const STATS_GROUP_SEVERITY_CRITICAL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity.critical', {
  defaultMessage: 'Critical'
});
exports.STATS_GROUP_SEVERITY_CRITICAL = STATS_GROUP_SEVERITY_CRITICAL;
const STATS_GROUP_SEVERITY_MEDIUM = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.groups.stats.severity.medium', {
  defaultMessage: 'Medium'
});
exports.STATS_GROUP_SEVERITY_MEDIUM = STATS_GROUP_SEVERITY_MEDIUM;
const ruleName = _i18n.i18n.translate('xpack.securitySolution.selector.groups.ruleName.label', {
  defaultMessage: 'Rule name'
});
exports.ruleName = ruleName;
const userName = _i18n.i18n.translate('xpack.securitySolution.selector.grouping.userName.label', {
  defaultMessage: 'User name'
});
exports.userName = userName;
const hostName = _i18n.i18n.translate('xpack.securitySolution.selector.grouping.hostName.label', {
  defaultMessage: 'Host name'
});
exports.hostName = hostName;
const sourceIP = _i18n.i18n.translate('xpack.securitySolution.selector.grouping.sourceIP.label', {
  defaultMessage: 'Source IP'
});
exports.sourceIP = sourceIP;
const sourceAddress = _i18n.i18n.translate('xpack.securitySolution.selector.groups.sourceAddress.label', {
  defaultMessage: 'Source address'
});
exports.sourceAddress = sourceAddress;
const destinationAddress = _i18n.i18n.translate('xpack.securitySolution.selector.groups.destinationAddress.label', {
  defaultMessage: 'Destination address'
});
exports.destinationAddress = destinationAddress;
const INSPECT_GROUPING_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionsEngine.grouping.inspectTitle', {
  defaultMessage: 'Grouping query'
});
exports.INSPECT_GROUPING_TITLE = INSPECT_GROUPING_TITLE;
const EVENT_RENDERED_VIEW_COLUMNS = {
  timestamp: _i18n.i18n.translate('xpack.securitySolution.EventRenderedView.timestampTitle.column', {
    defaultMessage: 'Timestamp'
  }),
  rule: _i18n.i18n.translate('xpack.securitySolution.EventRenderedView.ruleTitle.column', {
    defaultMessage: 'Rule'
  }),
  eventSummary: _i18n.i18n.translate('xpack.securitySolution.EventRenderedView.eventSummary.column', {
    defaultMessage: 'Event Summary'
  })
};
exports.EVENT_RENDERED_VIEW_COLUMNS = EVENT_RENDERED_VIEW_COLUMNS;