"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOpenAlertDetailsAction = exports.ACTION_OPEN_ALERT_DETAILS_PAGE = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _links = require("../../../../common/components/links");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _link_to = require("../../../../common/components/link_to");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTION_OPEN_ALERT_DETAILS_PAGE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.alerts.actions.openAlertDetails', {
  defaultMessage: 'Open alert details page'
});
exports.ACTION_OPEN_ALERT_DETAILS_PAGE = ACTION_OPEN_ALERT_DETAILS_PAGE;
const useOpenAlertDetailsAction = ({
  ruleId,
  closePopover,
  alertId
}) => {
  const isAlertDetailsPageEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('alertDetailsPageEnabled');
  const alertDetailsActionItems = [];
  const {
    onClick
  } = (0, _links.useGetSecuritySolutionLinkProps)()({
    deepLinkId: _constants.SecurityPageName.alerts,
    path: alertId ? (0, _link_to.getAlertDetailsUrl)(alertId) : ''
  });

  // We check ruleId to confirm this is an alert, as this page does not support events as of 8.6
  if (ruleId && alertId && isAlertDetailsPageEnabled) {
    alertDetailsActionItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "open-alert-details-item",
      "data-test-subj": "open-alert-details-page-menu-item",
      onClick: onClick
    }, ACTION_OPEN_ALERT_DETAILS_PAGE));
  }
  return {
    alertDetailsActionItems
  };
};
exports.useOpenAlertDetailsAction = useOpenAlertDetailsAction;