"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExceptionActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _user_info = require("../../user_info");
var _translations = require("../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useExceptionActions = ({
  isEndpointAlert,
  onAddExceptionTypeClick
}) => {
  const [{
    canUserCRUD,
    hasIndexWrite
  }] = (0, _user_info.useUserData)();
  const handleDetectionExceptionModal = (0, _react.useCallback)(() => {
    onAddExceptionTypeClick();
  }, [onAddExceptionTypeClick]);
  const handleEndpointExceptionModal = (0, _react.useCallback)(() => {
    onAddExceptionTypeClick(_securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT);
  }, [onAddExceptionTypeClick]);
  const disabledAddEndpointException = !canUserCRUD || !hasIndexWrite || !isEndpointAlert;
  const disabledAddException = !canUserCRUD || !hasIndexWrite;
  const exceptionActionItems = (0, _react.useMemo)(() => disabledAddException ? [] : [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "add-endpoint-exception-menu-item",
    "data-test-subj": "add-endpoint-exception-menu-item",
    disabled: disabledAddEndpointException,
    onClick: handleEndpointExceptionModal
  }, _translations.ACTION_ADD_ENDPOINT_EXCEPTION), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "add-exception-menu-item",
    "data-test-subj": "add-exception-menu-item",
    disabled: disabledAddException,
    onClick: handleDetectionExceptionModal
  }, _translations.ACTION_ADD_EXCEPTION)], [disabledAddEndpointException, disabledAddException, handleDetectionExceptionModal, handleEndpointExceptionModal]);
  return {
    exceptionActionItems
  };
};
exports.useExceptionActions = useExceptionActions;