"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isInvestigateInResolverActionEnabled = void 0;
var _fp = require("lodash/fp");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isInvestigateInResolverActionEnabled = ecsData => {
  const agentType = (0, _fp.get)(['agent', 'type', 0], ecsData);
  const processEntityIds = (0, _fp.get)(['process', 'entity_id'], ecsData);
  const firstProcessEntityId = (0, _fp.get)(['process', 'entity_id', 0], ecsData);
  const eventModule = (0, _fp.get)(['event', 'module', 0], ecsData);
  const eventDataStream = (0, _fp.get)(['event', 'dataset'], ecsData);
  const datasetIncludesSysmon = Array.isArray(eventDataStream) && eventDataStream.some(datastream => datastream.includes('windows.sysmon'));
  const agentTypeIsEndpoint = agentType === 'endpoint';
  const agentTypeIsWinlogBeat = agentType === 'winlogbeat' && eventModule === 'sysmon';
  const isEndpointOrSysmonFromWinlogBeat = agentTypeIsEndpoint || agentTypeIsWinlogBeat || datasetIncludesSysmon;
  const hasProcessEntityId = processEntityIds != null && processEntityIds.length === 1 && firstProcessEntityId !== '';
  return isEndpointOrSysmonFromWinlogBeat && hasProcessEntityId;
};
exports.isInvestigateInResolverActionEnabled = isInvestigateInResolverActionEnabled;