"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FullWidthFlexGroupTable = exports.AlertsTableComponent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-utils-plugin/public");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRedux = require("react-redux");
var _public2 = require("@kbn/data-plugin/public");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_global_time = require("../../../common/containers/use_global_time");
var _use_license = require("../../../common/hooks/use_license");
var _constants = require("../../../../common/constants");
var _constants2 = require("../../../timelines/components/timeline/body/constants");
var _default_model = require("../../../common/components/events_viewer/default_model");
var _graph_overlay = require("../../../timelines/components/graph_overlay");
var _use_session_view = require("../../../timelines/components/timeline/session_tab_content/use_session_view");
var _store = require("../../../common/store");
var _kuery = require("../../../common/lib/kuery");
var _use_invalid_filter_query = require("../../../common/hooks/use_invalid_filter_query");
var _stateful_event_context = require("../../../common/components/events_viewer/stateful_event_context");
var _local_storage = require("../../../timelines/containers/local_storage");
var _sourcerer = require("../../../common/containers/sourcerer");
var _model = require("../../../common/store/sourcerer/model");
var _kibana = require("../../../common/lib/kibana");
var _use_selector = require("../../../common/hooks/use_selector");
var _security_solution_detections = require("../../configurations/security_solution_detections");
var _helpers = require("./helpers");
var _selectors = require("../../../common/components/events_viewer/selectors");
var i18n = _interopRequireWildcard(require("./translations"));
var _columns = require("../../configurations/security_solution_detections/columns");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  updateIsLoading,
  updateTotalCount
} = _securitysolutionDataTable.dataTableActions;

// Highlight rows with building block alerts
const shouldHighlightRow = alert => !!alert[_ruleDataUtils.ALERT_BUILDING_BLOCK_TYPE];
const storage = new _public.Storage(localStorage);
const FullWidthFlexGroupTable = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  overflow: hidden;
  margin: 0;
  display: ${({
  $visible
}) => $visible ? 'flex' : 'none'};
`;
exports.FullWidthFlexGroupTable = FullWidthFlexGroupTable;
const EuiDataGridContainer = _styledComponents.default.div`
  ul.euiPagination__list {
    li.euiPagination__item:last-child {
      ${({
  hideLastPage
}) => {
  return `${hideLastPage ? 'display:none' : ''}`;
}};
    }
  }
  div .euiDataGridRowCell__contentByHeight {
    height: auto;
    align-self: center;
  }
  div .euiDataGridRowCell--lastColumn .euiDataGridRowCell__contentByHeight {
    flex-grow: 0;
    width: 100%;
  }
  div .siemEventsTable__trSupplement--summary {
    display: block;
  }
  width: 100%;
`;
const AlertsTableComponent = ({
  configId,
  flyoutSize,
  inputFilters,
  tableId = _securitysolutionDataTable.TableId.alertsOnAlertsPage,
  sourcererScope = _model.SourcererScopeName.detections,
  isLoading,
  onRuleChange
}) => {
  var _dataTableStorage$Tab, _dataTableStorage$Tab2;
  const {
    triggersActionsUi,
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const {
    from,
    to,
    setQuery
  } = (0, _use_global_time.useGlobalTime)();
  const alertTableRefreshHandlerRef = (0, _react.useRef)(null);
  const dispatch = (0, _reactRedux.useDispatch)();

  // Store context in state rather than creating object in provider value={} to prevent re-renders caused by a new object being created
  const [activeStatefulEventContext] = (0, _react.useState)({
    timelineID: tableId,
    tabType: 'query',
    enableHostDetailsFlyout: true,
    enableIpDetailsFlyout: true,
    onRuleChange
  });
  const {
    browserFields,
    indexPattern: indexPatterns,
    runtimeMappings
  } = (0, _sourcerer.useSourcererDataView)(sourcererScope);
  const license = (0, _use_license.useLicense)();
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const globalQuery = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const isDataTableInitialized = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, tableId)) !== null && _getTable !== void 0 ? _getTable : _securitysolutionDataTable.tableDefaults).initialized;
  });
  const timeRangeFilter = (0, _react.useMemo)(() => (0, _helpers.buildTimeRangeFilter)(from, to), [from, to]);
  const allFilters = (0, _react.useMemo)(() => {
    return [...inputFilters, ...(globalFilters !== null && globalFilters !== void 0 ? globalFilters : []), ...(timeRangeFilter !== null && timeRangeFilter !== void 0 ? timeRangeFilter : [])];
  }, [inputFilters, globalFilters, timeRangeFilter]);
  const {
    dataTable: {
      graphEventId,
      // If truthy, the graph viewer (Resolver) is showing
      sessionViewConfig,
      viewMode: tableView = _default_model.eventsDefaultModel.viewMode
    } = _default_model.eventsDefaultModel
  } = (0, _use_selector.useShallowEqualSelector)(state => (0, _selectors.eventsViewerSelector)(state, tableId));
  const combinedQuery = (0, _react.useMemo)(() => {
    if (browserFields != null && indexPatterns != null) {
      return (0, _kuery.combineQueries)({
        config: (0, _public2.getEsQueryConfig)(uiSettings),
        dataProviders: [],
        indexPattern: indexPatterns,
        browserFields,
        filters: [...allFilters],
        kqlQuery: globalQuery,
        kqlMode: globalQuery.language
      });
    }
    return null;
  }, [browserFields, globalQuery, indexPatterns, uiSettings, allFilters]);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: tableId,
    filterQuery: combinedQuery === null || combinedQuery === void 0 ? void 0 : combinedQuery.filterQuery,
    kqlError: combinedQuery === null || combinedQuery === void 0 ? void 0 : combinedQuery.kqlError,
    query: globalQuery,
    startDate: from,
    endDate: to
  });
  const finalBoolQuery = (0, _react.useMemo)(() => {
    if (combinedQuery !== null && combinedQuery !== void 0 && combinedQuery.kqlError || !(combinedQuery !== null && combinedQuery !== void 0 && combinedQuery.filterQuery)) {
      return {
        bool: {}
      };
    }
    return {
      bool: {
        filter: JSON.parse(combinedQuery === null || combinedQuery === void 0 ? void 0 : combinedQuery.filterQuery)
      }
    };
  }, [combinedQuery === null || combinedQuery === void 0 ? void 0 : combinedQuery.filterQuery, combinedQuery === null || combinedQuery === void 0 ? void 0 : combinedQuery.kqlError]);
  const isEventRenderedView = tableView === _constants.VIEW_SELECTION.eventRenderedView;
  const gridStyle = (0, _react.useMemo)(() => ({
    border: 'none',
    fontSize: 's',
    header: 'underline',
    stripes: isEventRenderedView
  }), [isEventRenderedView]);
  const rowHeightsOptions = (0, _react.useMemo)(() => {
    if (isEventRenderedView) {
      return {
        defaultHeight: 'auto'
      };
    }
    return undefined;
  }, [isEventRenderedView]);
  const dataTableStorage = (0, _local_storage.getDataTablesInStorageByIds)(storage, [_securitysolutionDataTable.TableId.alertsOnAlertsPage]);
  const columnsFormStorage = (_dataTableStorage$Tab = dataTableStorage === null || dataTableStorage === void 0 ? void 0 : (_dataTableStorage$Tab2 = dataTableStorage[_securitysolutionDataTable.TableId.alertsOnAlertsPage]) === null || _dataTableStorage$Tab2 === void 0 ? void 0 : _dataTableStorage$Tab2.columns) !== null && _dataTableStorage$Tab !== void 0 ? _dataTableStorage$Tab : [];
  const alertColumns = columnsFormStorage.length ? columnsFormStorage : (0, _security_solution_detections.getColumns)(license);
  const finalBrowserFields = (0, _react.useMemo)(() => isEventRenderedView ? {} : browserFields, [isEventRenderedView, browserFields]);
  const finalColumns = (0, _react.useMemo)(() => isEventRenderedView ? _columns.eventRenderedViewColumns : alertColumns, [alertColumns, isEventRenderedView]);
  const onAlertTableUpdate = (0, _react.useCallback)(({
    isLoading: isAlertTableLoading,
    totalCount,
    refresh
  }) => {
    dispatch(updateIsLoading({
      id: tableId,
      isLoading: isAlertTableLoading
    }));
    dispatch(updateTotalCount({
      id: tableId,
      totalCount
    }));
    alertTableRefreshHandlerRef.current = refresh;

    // setting Query
    setQuery({
      id: tableId,
      loading: isAlertTableLoading,
      refetch: refresh,
      inspect: null
    });
  }, [dispatch, tableId, alertTableRefreshHandlerRef, setQuery]);
  const alertStateProps = (0, _react.useMemo)(() => ({
    alertsTableConfigurationRegistry: triggersActionsUi.alertsTableConfigurationRegistry,
    configurationId: configId,
    // stores saperate configuration based on the view of the table
    id: `detection-engine-alert-table-${configId}-${tableView}`,
    flyoutSize,
    featureIds: ['siem'],
    query: finalBoolQuery,
    showExpandToDetails: false,
    gridStyle,
    shouldHighlightRow,
    rowHeightsOptions,
    columns: finalColumns,
    browserFields: finalBrowserFields,
    onUpdate: onAlertTableUpdate,
    runtimeMappings,
    toolbarVisibility: {
      showColumnSelector: !isEventRenderedView,
      showSortSelector: !isEventRenderedView
    }
  }), [triggersActionsUi.alertsTableConfigurationRegistry, configId, tableView, flyoutSize, finalBoolQuery, gridStyle, rowHeightsOptions, finalColumns, finalBrowserFields, onAlertTableUpdate, runtimeMappings, isEventRenderedView]);
  (0, _react.useEffect)(() => {
    if (isDataTableInitialized) return;
    dispatch(_securitysolutionDataTable.dataTableActions.initializeDataTableSettings({
      id: tableId,
      title: i18n.SESSIONS_TITLE,
      defaultColumns: finalColumns.map(c => ({
        initialWidth: _constants2.DEFAULT_COLUMN_MIN_WIDTH,
        ...c
      }))
    }));
  }, [dispatch, tableId, finalColumns, isDataTableInitialized]);
  const AlertTable = (0, _react.useMemo)(() => triggersActionsUi.getAlertsStateTable(alertStateProps), [alertStateProps, triggersActionsUi]);
  const {
    Navigation
  } = (0, _use_session_view.useSessionViewNavigation)({
    scopeId: tableId
  });
  const {
    DetailsPanel,
    SessionView
  } = (0, _use_session_view.useSessionView)({
    entityType: 'events',
    scopeId: tableId
  });
  const graphOverlay = (0, _react.useMemo)(() => {
    const shouldShowOverlay = graphEventId != null && graphEventId.length > 0 || sessionViewConfig != null;
    return shouldShowOverlay ? /*#__PURE__*/_react.default.createElement(_graph_overlay.GraphOverlay, {
      scopeId: tableId,
      SessionView: SessionView,
      Navigation: Navigation
    }) : null;
  }, [graphEventId, tableId, sessionViewConfig, SessionView, Navigation]);
  if (isLoading) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", null, graphOverlay, /*#__PURE__*/_react.default.createElement(FullWidthFlexGroupTable, {
    $visible: !graphEventId && graphOverlay == null,
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_stateful_event_context.StatefulEventContext.Provider, {
    value: activeStatefulEventContext
  }, /*#__PURE__*/_react.default.createElement(EuiDataGridContainer, {
    hideLastPage: false
  }, AlertTable))), DetailsPanel);
};
exports.AlertsTableComponent = AlertsTableComponent;