"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  getDefaultGroupingOptions: true
};
exports.getDefaultGroupingOptions = void 0;
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var i18n = _interopRequireWildcard(require("../translations"));
var _group_stats = require("./group_stats");
Object.keys(_group_stats).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _group_stats[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _group_stats[key];
    }
  });
});
var _group_panel_renderers = require("./group_panel_renderers");
Object.keys(_group_panel_renderers).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _group_panel_renderers[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _group_panel_renderers[key];
    }
  });
});
var _group_take_action_items = require("./group_take_action_items");
Object.keys(_group_take_action_items).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _group_take_action_items[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _group_take_action_items[key];
    }
  });
});
var _query_builder = require("./query_builder");
Object.keys(_query_builder).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _query_builder[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _query_builder[key];
    }
  });
});
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultGroupingOptions = tableId => {
  if (tableId === _securitysolutionDataTable.TableId.alertsOnAlertsPage) {
    return [{
      label: i18n.ruleName,
      key: 'kibana.alert.rule.name'
    }, {
      label: i18n.userName,
      key: 'user.name'
    }, {
      label: i18n.hostName,
      key: 'host.name'
    }, {
      label: i18n.sourceIP,
      key: 'source.ip'
    }];
  } else if (tableId === _securitysolutionDataTable.TableId.alertsOnRuleDetailsPage) {
    return [{
      label: i18n.sourceAddress,
      key: 'source.address'
    }, {
      label: i18n.userName,
      key: 'user.name'
    }, {
      label: i18n.hostName,
      key: 'host.name'
    }, {
      label: i18n.destinationAddress,
      key: 'destination.address,'
    }];
  }
  return [];
};
exports.getDefaultGroupingOptions = getDefaultGroupingOptions;