"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGroupTakeActionsItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _store = require("../../../../common/store");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _constants = require("../../../../common/lib/apm/constants");
var _use_update_alerts = require("../../../../common/components/toolbar/bulk_actions/use_update_alerts");
var _translations = require("../../../../common/components/toolbar/bulk_actions/translations");
var _translations2 = require("../../../../common/translations");
var _types = require("../../../../../common/types");
var _use_selector = require("../../../../common/hooks/use_selector");
var i18n = _interopRequireWildcard(require("../translations"));
var _telemetry = require("../../../../common/lib/telemetry");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGroupTakeActionsItems = ({
  currentStatus,
  indexName,
  showAlertStatusActions = true
}) => {
  const {
    updateAlertStatus
  } = (0, _use_update_alerts.useUpdateAlertsStatus)();
  const {
    addSuccess,
    addError,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const getGlobalQuerySelector = _store.inputsSelectors.globalQuery();
  const globalQueries = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const refetchQuery = (0, _react.useCallback)(() => {
    globalQueries.forEach(q => q.refetch && q.refetch());
  }, [globalQueries]);
  const {
    services: {
      telemetry
    }
  } = (0, _public.useKibana)();
  const reportAlertsGroupingTakeActionClick = (0, _react.useCallback)(params => {
    telemetry.reportAlertsGroupingTakeAction(params);
  }, [telemetry]);
  const onUpdateSuccess = (0, _react.useCallback)((updated, conflicts, newStatus) => {
    refetchQuery();
  }, [refetchQuery]);
  const onUpdateFailure = (0, _react.useCallback)((newStatus, error) => {
    refetchQuery();
  }, [refetchQuery]);
  const onAlertStatusUpdateSuccess = (0, _react.useCallback)((updated, conflicts, newStatus) => {
    if (conflicts > 0) {
      // Partial failure
      addWarning({
        title: (0, _translations2.UPDATE_ALERT_STATUS_FAILED)(conflicts),
        text: (0, _translations2.UPDATE_ALERT_STATUS_FAILED_DETAILED)(updated, conflicts)
      });
    } else {
      let title;
      switch (newStatus) {
        case 'closed':
          title = i18n.CLOSED_ALERT_SUCCESS_TOAST(updated);
          break;
        case 'open':
          title = i18n.OPENED_ALERT_SUCCESS_TOAST(updated);
          break;
        case 'acknowledged':
          title = i18n.ACKNOWLEDGED_ALERT_SUCCESS_TOAST(updated);
      }
      addSuccess({
        title
      });
    }
    if (onUpdateSuccess) {
      onUpdateSuccess(updated, conflicts, newStatus);
    }
  }, [addSuccess, addWarning, onUpdateSuccess]);
  const onAlertStatusUpdateFailure = (0, _react.useCallback)((newStatus, error) => {
    let title;
    switch (newStatus) {
      case 'closed':
        title = i18n.CLOSED_ALERT_FAILED_TOAST;
        break;
      case 'open':
        title = i18n.OPENED_ALERT_FAILED_TOAST;
        break;
      case 'acknowledged':
        title = i18n.ACKNOWLEDGED_ALERT_FAILED_TOAST;
    }
    addError(error.message, {
      title
    });
    if (onUpdateFailure) {
      onUpdateFailure(newStatus, error);
    }
  }, [addError, onUpdateFailure]);
  const onClickUpdate = (0, _react.useCallback)(async ({
    groupNumber,
    query,
    status,
    tableId,
    selectedGroup
  }) => {
    if (query) {
      startTransaction({
        name: _constants.APM_USER_INTERACTIONS.BULK_QUERY_STATUS_UPDATE
      });
    } else {
      startTransaction({
        name: _constants.APM_USER_INTERACTIONS.STATUS_UPDATE
      });
    }
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.CLICK, _telemetry.getTelemetryEvent.groupedAlertsTakeAction({
      tableId,
      groupNumber,
      status
    }));
    reportAlertsGroupingTakeActionClick({
      tableId,
      groupNumber,
      status,
      groupByField: selectedGroup
    });
    try {
      var _response$updated, _response$version_con;
      const response = await updateAlertStatus({
        index: indexName,
        status,
        query: query ? JSON.parse(query) : {}
      });
      onAlertStatusUpdateSuccess((_response$updated = response.updated) !== null && _response$updated !== void 0 ? _response$updated : 0, (_response$version_con = response.version_conflicts) !== null && _response$version_con !== void 0 ? _response$version_con : 0, status);
    } catch (error) {
      onAlertStatusUpdateFailure(status, error);
    }
  }, [startTransaction, reportAlertsGroupingTakeActionClick, updateAlertStatus, indexName, onAlertStatusUpdateSuccess, onAlertStatusUpdateFailure]);
  return (0, _react.useMemo)(() => {
    const getActionItems = ({
      query,
      tableId,
      groupNumber,
      selectedGroup
    }) => {
      const actionItems = [];
      if (showAlertStatusActions) {
        if (currentStatus && currentStatus.length === 1) {
          const singleStatus = currentStatus[0];
          if (singleStatus !== _types.FILTER_OPEN) {
            actionItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
              key: "open",
              "data-test-subj": "open-alert-status",
              onClick: () => onClickUpdate({
                groupNumber,
                query,
                selectedGroup,
                status: _types.FILTER_OPEN,
                tableId
              })
            }, _translations.BULK_ACTION_OPEN_SELECTED));
          }
          if (singleStatus !== _types.FILTER_ACKNOWLEDGED) {
            actionItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
              key: "acknowledge",
              "data-test-subj": "acknowledged-alert-status",
              onClick: () => onClickUpdate({
                groupNumber,
                query,
                selectedGroup,
                status: _types.FILTER_ACKNOWLEDGED,
                tableId
              })
            }, _translations.BULK_ACTION_ACKNOWLEDGED_SELECTED));
          }
          if (singleStatus !== _types.FILTER_CLOSED) {
            actionItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
              key: "close",
              "data-test-subj": "close-alert-status",
              onClick: () => onClickUpdate({
                groupNumber,
                query,
                selectedGroup,
                status: _types.FILTER_CLOSED,
                tableId
              })
            }, _translations.BULK_ACTION_CLOSE_SELECTED));
          }
        } else {
          const statusArr = {
            [_types.FILTER_OPEN]: _translations.BULK_ACTION_OPEN_SELECTED,
            [_types.FILTER_ACKNOWLEDGED]: _translations.BULK_ACTION_ACKNOWLEDGED_SELECTED,
            [_types.FILTER_CLOSED]: _translations.BULK_ACTION_CLOSE_SELECTED
          };
          Object.keys(statusArr).forEach(workflowStatus => actionItems.push( /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
            key: workflowStatus,
            "data-test-subj": `${workflowStatus}-alert-status`,
            onClick: () => onClickUpdate({
              groupNumber,
              query,
              selectedGroup,
              status: workflowStatus,
              tableId
            })
          }, statusArr[workflowStatus])));
        }
      }
      return actionItems;
    };
    return getActionItems;
  }, [currentStatus, onClickUpdate, showAlertStatusActions]);
};
exports.useGroupTakeActionsItems = useGroupTakeActionsItems;