"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderGroupPanel = void 0;
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _ecs_safety_helpers = require("../../../../../common/endpoint/models/ecs_safety_helpers");
var _popover_items = require("../../../../common/components/popover_items");
var _translations = require("../../../pages/detection_engine/rules/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderGroupPanel = (selectedGroup, bucket, nullGroupMessage) => {
  var _firstNonNullValue, _firstNonNullValue2, _bucket$description, _bucket$ruleTags;
  switch (selectedGroup) {
    case 'kibana.alert.rule.name':
      return (0, _fp.isArray)(bucket.key) ? /*#__PURE__*/_react.default.createElement(RuleNameGroupContent, {
        ruleName: bucket.key[0],
        ruleDescription: (_firstNonNullValue = (0, _ecs_safety_helpers.firstNonNullValue)((_firstNonNullValue2 = (0, _ecs_safety_helpers.firstNonNullValue)((_bucket$description = bucket.description) === null || _bucket$description === void 0 ? void 0 : _bucket$description.buckets)) === null || _firstNonNullValue2 === void 0 ? void 0 : _firstNonNullValue2.key)) !== null && _firstNonNullValue !== void 0 ? _firstNonNullValue : '',
        tags: (_bucket$ruleTags = bucket.ruleTags) === null || _bucket$ruleTags === void 0 ? void 0 : _bucket$ruleTags.buckets
      }) : undefined;
    case 'host.name':
      return /*#__PURE__*/_react.default.createElement(HostNameGroupContent, {
        hostName: bucket.key,
        nullGroupMessage: nullGroupMessage
      });
    case 'user.name':
      return /*#__PURE__*/_react.default.createElement(UserNameGroupContent, {
        userName: bucket.key,
        nullGroupMessage: nullGroupMessage
      });
    case 'source.ip':
      return /*#__PURE__*/_react.default.createElement(SourceIpGroupContent, {
        sourceIp: bucket.key,
        nullGroupMessage: nullGroupMessage
      });
  }
};
exports.renderGroupPanel = renderGroupPanel;
const RuleNameGroupContent = /*#__PURE__*/_react.default.memo(({
  ruleName,
  ruleDescription,
  tags
}) => {
  const renderItem = (tag, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    key: `${tag}-${i}`,
    "data-test-subj": "tag"
  }, tag);
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'table',
      tableLayout: 'fixed',
      width: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "rule-name-group-renderer",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      display: 'contents'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", {
    className: "eui-textTruncate"
  }, ruleName.trim()))), tags && tags.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_popover_items.PopoverItems, {
    items: tags.map(tag => tag.key.toString()),
    popoverTitle: _translations.COLUMN_TAGS,
    popoverButtonTitle: tags.length.toString(),
    popoverButtonIcon: "tag",
    dataTestPrefix: "tags",
    renderItem: renderItem
  })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", {
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, ruleDescription))));
});
RuleNameGroupContent.displayName = 'RuleNameGroup';
const HostNameGroupContent = /*#__PURE__*/_react.default.memo(({
  hostName,
  nullGroupMessage
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  "data-test-subj": "host-name-group-renderer",
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  style: {
    backgroundColor: _uiTheme.euiThemeVars.euiColorVis1_behindText,
    borderRadius: '50%'
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: "database",
  size: "l",
  style: {
    padding: 4
  }
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h5", null, hostName))), nullGroupMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: nullGroupMessage,
  position: "right"
}))));
HostNameGroupContent.displayName = 'HostNameGroupContent';
const UserNameGroupContent = /*#__PURE__*/_react.default.memo(({
  userName,
  nullGroupMessage
}) => {
  var _firstNonNullValue3;
  const userNameValue = (_firstNonNullValue3 = (0, _ecs_safety_helpers.firstNonNullValue)(userName)) !== null && _firstNonNullValue3 !== void 0 ? _firstNonNullValue3 : '-';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "user-name-group-renderer",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    name: userNameValue,
    color: _uiTheme.euiThemeVars.euiColorVis0
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, userName))), nullGroupMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: nullGroupMessage,
    position: "right"
  })));
});
UserNameGroupContent.displayName = 'UserNameGroupContent';
const SourceIpGroupContent = /*#__PURE__*/_react.default.memo(({
  sourceIp,
  nullGroupMessage
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  "data-test-subj": "source-ip-group-renderer",
  gutterSize: "s",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  style: {
    backgroundColor: _uiTheme.euiThemeVars.euiColorVis3_behindText,
    borderRadius: '50%'
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  style: {
    padding: 4
  },
  type: "ip",
  size: "l"
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("h5", null, sourceIp))), nullGroupMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
  content: nullGroupMessage,
  position: "right"
}))));
SourceIpGroupContent.displayName = 'SourceIpGroupContent';