"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseData = void 0;
var _helpers = require("../severity_level_panel/helpers");
var _helpers2 = require("../alerts_by_type_panel/helpers");
var _helpers3 = require("../alerts_progress_bar_panel/helpers");
var _helpers4 = require("../../../pages/detection_engine/chart_panels/chart_collapse/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseData = data => {
  if ((0, _helpers.getIsAlertsBySeverityAgg)(data)) {
    return (0, _helpers.parseSeverityData)(data);
  }
  if ((0, _helpers2.getIsAlertsByTypeAgg)(data)) {
    return (0, _helpers2.parseAlertsTypeData)(data);
  }
  if ((0, _helpers2.getIsAlertsByRuleAgg)(data)) {
    return (0, _helpers2.parseAlertsRuleData)(data);
  }
  if ((0, _helpers3.getIsAlertsByGroupingAgg)(data)) {
    return (0, _helpers3.parseAlertsGroupingData)(data);
  }
  if ((0, _helpers4.getIsChartCollapseAgg)(data)) {
    return (0, _helpers4.parseChartCollapseData)(data);
  }
  return [];
};
exports.parseData = parseData;