"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChartContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _visualization_embeddable = require("../../../../common/components/visualization_actions/visualization_embeddable");
var _alerts_count = require("./alerts_count");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartContentComponent = ({
  alertsData,
  extraActions,
  extraOptions,
  getLensAttributes,
  height,
  id,
  inspectTitle,
  isChartEmbeddablesEnabled,
  isLoadingAlerts,
  scopeId,
  stackByField0,
  stackByField1,
  timerange
}) => {
  return isChartEmbeddablesEnabled ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    "data-test-subj": "embeddable-alerts-count",
    extraActions: extraActions,
    extraOptions: extraOptions,
    getLensAttributes: getLensAttributes,
    height: height,
    id: id,
    inspectTitle: inspectTitle,
    scopeId: scopeId,
    stackByField: stackByField0,
    timerange: timerange
  }) : alertsData != null ? /*#__PURE__*/_react.default.createElement(_alerts_count.AlertsCount, {
    data: alertsData,
    loading: isLoadingAlerts,
    stackByField0: stackByField0,
    stackByField1: stackByField1
  }) : null;
};
const ChartContent = /*#__PURE__*/_react.default.memo(ChartContentComponent);
exports.ChartContent = ChartContent;