"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _react2 = require("@emotion/react");
var _response_actions_wrapper = require("./response_actions_wrapper");
var _translations = require("../../detections/components/rules/rule_actions_field/translations");
var _response_actions_header = require("./response_actions_header");
var _use_supported_response_action_types = require("./use_supported_response_action_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldErrorsContainer = (0, _react2.css)`
  margin-bottom: 0;
`;
const ResponseActionsForm = ({
  items,
  addItem,
  removeItem,
  form
}) => {
  const supportedResponseActionTypes = (0, _use_supported_response_action_types.useSupportedResponseActionTypes)();
  const [uiFieldErrors, setUIFieldErrors] = (0, _react.useState)(null);
  const fields = form.getFields();
  const errors = form.getErrors();
  const formContent = (0, _react.useMemo)(() => {
    if (!(supportedResponseActionTypes !== null && supportedResponseActionTypes !== void 0 && supportedResponseActionTypes.length)) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_response_actions_wrapper.ResponseActionsWrapper, {
      items: items,
      removeItem: removeItem,
      supportedResponseActionTypes: supportedResponseActionTypes,
      addItem: addItem
    });
  }, [addItem, items, removeItem, supportedResponseActionTypes]);
  (0, _react.useEffect)(() => {
    setUIFieldErrors(() => {
      const fieldErrors = (0, _lodash.reduce)((0, _lodash.map)(items, 'path'), (acc, path) => {
        var _fields, _fields$errors;
        if ((_fields = fields[`${path}.params`]) !== null && _fields !== void 0 && (_fields$errors = _fields.errors) !== null && _fields$errors !== void 0 && _fields$errors.length) {
          acc.push({
            type: (0, _lodash.upperFirst)(fields[`${path}.actionTypeId`].value.substring(1)),
            errors: (0, _lodash.map)(fields[`${path}.params`].errors, 'message')
          });
          return acc;
        }
        return acc;
      }, []);
      return (0, _lodash.reduce)(fieldErrors, (acc, error) => {
        acc.push(`**${error.type}:**\n`);
        error.errors.forEach(err => {
          acc.push(`- ${err}\n`);
        });
        return acc;
      }, []).join('\n');
    });
  }, [fields, errors, items]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    "data-test-subj": 'response-actions-form'
  }), /*#__PURE__*/_react.default.createElement(_response_actions_header.ResponseActionsHeader, null), uiFieldErrors !== null && uiFieldErrors !== void 0 && uiFieldErrors.length && form.isSubmitted ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
    css: FieldErrorsContainer
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "response-actions-error",
    title: _translations.FORM_ERRORS_TITLE,
    color: "danger",
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement(_reactMarkdown.default, null, uiFieldErrors))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, formContent);
};
exports.ResponseActionsForm = ResponseActionsForm;