"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryResponseAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _securitysolutionHookUtils = require("@kbn/securitysolution-hook-utils");
var _osquery_response_action_form_field = require("./osquery_response_action_form_field");
var _kibana = require("../../../common/lib/kibana");
var _translations = require("./translations");
var _shared_imports = require("../../../shared_imports");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GhostFormField = () => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
const OsqueryResponseAction = /*#__PURE__*/_react.default.memo(props => {
  const {
    osquery,
    application
  } = (0, _kibana.useKibana)().services;
  const OsqueryForm = (0, _react.useMemo)(() => osquery === null || osquery === void 0 ? void 0 : osquery.OsqueryResponseActionTypeForm, [osquery === null || osquery === void 0 ? void 0 : osquery.OsqueryResponseActionTypeForm]);
  const isMounted = (0, _securitysolutionHookUtils.useIsMounted)();
  if (osquery) {
    var _application$capabili, _application$capabili2, _application$capabili3, _application$capabili4, _application$capabili5, _application$capabili6, _application$capabili7, _application$capabili8;
    const {
      disabled,
      permissionDenied
    } = osquery.fetchInstallationStatus();
    const disabledOsqueryPermission = !(application !== null && application !== void 0 && (_application$capabili = application.capabilities) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.osquery) !== null && _application$capabili2 !== void 0 && _application$capabili2.writeLiveQueries || application !== null && application !== void 0 && (_application$capabili3 = application.capabilities) !== null && _application$capabili3 !== void 0 && (_application$capabili4 = _application$capabili3.osquery) !== null && _application$capabili4 !== void 0 && _application$capabili4.runSavedQueries && (application !== null && application !== void 0 && (_application$capabili5 = application.capabilities) !== null && _application$capabili5 !== void 0 && (_application$capabili6 = _application$capabili5.osquery) !== null && _application$capabili6 !== void 0 && _application$capabili6.readSavedQueries || application !== null && application !== void 0 && (_application$capabili7 = application.capabilities) !== null && _application$capabili7 !== void 0 && (_application$capabili8 = _application$capabili7.osquery) !== null && _application$capabili8 !== void 0 && _application$capabili8.readPacks));
    if (permissionDenied || disabledOsqueryPermission) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
        path: `${props.item.path}.params`,
        component: GhostFormField
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.PERMISSION_DENIED),
        titleSize: "xs",
        iconType: "logoOsquery",
        body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.osquery.action.missingPrivileges",
          defaultMessage: "To access this page, ask your administrator for {osquery} Kibana privileges.",
          values: {
            osquery: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'osquery')
          }
        }))
      }));
    }
    if (disabled) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
        path: `${props.item.path}.params`,
        component: GhostFormField
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        iconType: "logoOsquery",
        title: /*#__PURE__*/_react.default.createElement("h2", null, _translations.SHORT_EMPTY_TITLE),
        titleSize: "xs",
        body: /*#__PURE__*/_react.default.createElement("p", null, _translations.NOT_AVAILABLE)
      }));
    }
    if (isMounted() && OsqueryForm) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
        path: `${props.item.path}.params`,
        component: _osquery_response_action_form_field.ResponseActionFormField,
        readDefaultValueOnForm: !props.item.isNew
      });
    }
  }
  return null;
});
exports.OsqueryResponseAction = OsqueryResponseAction;
OsqueryResponseAction.displayName = 'OsqueryResponseAction';