"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.responseActionTypes = exports.getSupportedResponseActions = void 0;
var _schemas = require("../../../common/detection_engine/rule_response_actions/schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSupportedResponseActions = (actionTypes, enabledFeatures, userPermissions) => actionTypes.reduce((acc, actionType) => {
  const isEndpointAction = actionType.id === _schemas.RESPONSE_ACTION_TYPES.ENDPOINT;
  if (!enabledFeatures.endpoint && isEndpointAction) return acc;
  if (_schemas.SUPPORTED_RESPONSE_ACTION_TYPES.includes(actionType.id)) return [...acc, {
    ...actionType,
    disabled: isEndpointAction ? !userPermissions.endpoint : undefined
  }];
  return acc;
}, []);
exports.getSupportedResponseActions = getSupportedResponseActions;
const responseActionTypes = [{
  id: _schemas.RESPONSE_ACTION_TYPES.OSQUERY,
  name: 'Osquery',
  iconClass: 'logoOsquery'
}, {
  id: _schemas.RESPONSE_ACTION_TYPES.ENDPOINT,
  name: 'Endpoint Security',
  iconClass: 'logoSecurity'
}];
exports.responseActionTypes = responseActionTypes;