"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CommentField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CONFIG = {
  label: _i18n.i18n.translate('xpack.securitySolution.responseActions.endpoint.commentLabel', {
    defaultMessage: 'Comment (optional)'
  })
};
const CommentFieldComponent = ({
  basePath,
  disabled,
  readDefaultValueOnForm
}) => /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
  path: `${basePath}.comment`,
  readDefaultValueOnForm: readDefaultValueOnForm,
  config: CONFIG,
  isDisabled: disabled,
  component: _components.TextField
});
const CommentField = /*#__PURE__*/_react.default.memo(CommentFieldComponent);
exports.CommentField = CommentField;