"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCheckEndpointPermissions = void 0;
var _console_commands_definition = require("../../../management/components/endpoint_responder/lib/console_commands_definition");
var _hooks = require("../../../management/components/endpoint_response_actions_list/components/hooks");
var _user_privileges = require("../../../common/components/user_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCheckEndpointPermissions = action => {
  var _action$params;
  const endpointPrivileges = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  if ((action === null || action === void 0 ? void 0 : action.actionTypeId) === '.endpoint' && action !== null && action !== void 0 && (_action$params = action.params) !== null && _action$params !== void 0 && _action$params.command) {
    return !(0, _console_commands_definition.getRbacControl)({
      commandName: (0, _hooks.getUiCommand)(action.params.command),
      privileges: endpointPrivileges
    });
  }
};
exports.useCheckEndpointPermissions = useCheckEndpointPermissions;