"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionDetails = void 0;
var _schemas = require("../../../common/detection_engine/rule_response_actions/schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActionDetails = actionTypeId => {
  switch (actionTypeId) {
    case _schemas.RESPONSE_ACTION_TYPES.OSQUERY:
      return {
        logo: 'logoOsquery',
        name: 'Osquery'
      };
    case _schemas.RESPONSE_ACTION_TYPES.ENDPOINT:
      return {
        logo: 'logoSecurity',
        name: 'Endpoint'
      };
    // update when new responseActions are provided
    default:
      return {
        logo: 'logoOsquery',
        name: 'Osquery'
      };
  }
};
exports.getActionDetails = getActionDetails;