"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFilters = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFilters = () => {
  const [logLevels, setLogLevels] = (0, _react.useState)([]);
  const [eventTypes, setEventTypes] = (0, _react.useState)([]);
  const state = (0, _react.useMemo)(() => ({
    logLevels,
    eventTypes
  }), [logLevels, eventTypes]);
  return (0, _react.useMemo)(() => ({
    state,
    setLogLevels,
    setEventTypes
  }), [state, setLogLevels, setEventTypes]);
};
exports.useFilters = useFilters;