"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TABLE_TITLE = exports.TABLE_SUBTITLE = exports.ROW_DETAILS_MESSAGE = exports.ROW_DETAILS_JSON = exports.FETCH_ERROR = exports.COLUMN_TIMESTAMP = exports.COLUMN_MESSAGE = exports.COLUMN_LOG_LEVEL = exports.COLUMN_EVENT_TYPE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TABLE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleMonitoring.executionEventsTable.tableTitle', {
  defaultMessage: 'Execution log'
});
exports.TABLE_TITLE = TABLE_TITLE;
const TABLE_SUBTITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleMonitoring.executionEventsTable.tableSubtitle', {
  defaultMessage: 'A detailed log of rule execution events'
});
exports.TABLE_SUBTITLE = TABLE_SUBTITLE;
const COLUMN_TIMESTAMP = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleMonitoring.executionEventsTable.timestampColumn', {
  defaultMessage: 'Timestamp'
});
exports.COLUMN_TIMESTAMP = COLUMN_TIMESTAMP;
const COLUMN_LOG_LEVEL = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleMonitoring.executionEventsTable.logLevelColumn', {
  defaultMessage: 'Level'
});
exports.COLUMN_LOG_LEVEL = COLUMN_LOG_LEVEL;
const COLUMN_EVENT_TYPE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleMonitoring.executionEventsTable.eventTypeColumn', {
  defaultMessage: 'Type'
});
exports.COLUMN_EVENT_TYPE = COLUMN_EVENT_TYPE;
const COLUMN_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleMonitoring.executionEventsTable.messageColumn', {
  defaultMessage: 'Message'
});
exports.COLUMN_MESSAGE = COLUMN_MESSAGE;
const FETCH_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleMonitoring.executionEventsTable.fetchErrorDescription', {
  defaultMessage: 'Failed to fetch rule execution events'
});
exports.FETCH_ERROR = FETCH_ERROR;
const ROW_DETAILS_MESSAGE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleMonitoring.executionEventsTable.rowDetails.messageTitle', {
  defaultMessage: 'Message'
});
exports.ROW_DETAILS_MESSAGE = ROW_DETAILS_MESSAGE;
const ROW_DETAILS_JSON = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.ruleMonitoring.executionEventsTable.rowDetails.jsonTitle', {
  defaultMessage: 'Full JSON'
});
exports.ROW_DETAILS_JSON = ROW_DETAILS_JSON;