"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecutionEventsTableRowDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _text_block = require("../basic/text/text_block");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExecutionEventsTableRowDetailsComponent = ({
  item
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    className: "eui-fullWidth",
    listItems: [{
      title: i18n.ROW_DETAILS_MESSAGE,
      description: /*#__PURE__*/_react.default.createElement(_text_block.TextBlock, {
        text: item.message
      })
    }, {
      title: i18n.ROW_DETAILS_JSON,
      description: /*#__PURE__*/_react.default.createElement(_text_block.TextBlock, {
        text: JSON.stringify(item, null, 2)
      })
    }]
  });
};
const ExecutionEventsTableRowDetails = /*#__PURE__*/_react.default.memo(ExecutionEventsTableRowDetailsComponent);
exports.ExecutionEventsTableRowDetails = ExecutionEventsTableRowDetails;
ExecutionEventsTableRowDetails.displayName = 'ExecutionEventsTableRowDetails';