"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiselectFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _use_bool_state = require("../../../../../../common/hooks/use_bool_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MultiselectFilterComponent = props => {
  const {
    dataTestSubj,
    title,
    items,
    selectedItems,
    onSelectionChange,
    renderItem,
    renderLabel
  } = initializeProps(props);
  const [isPopoverOpen,, closePopover, togglePopover] = (0, _use_bool_state.useBoolState)();
  const handleItemClick = (0, _react.useCallback)(item => {
    const newSelectedItems = selectedItems.includes(item) ? selectedItems.filter(i => i !== item) : [...selectedItems, item];
    onSelectionChange(newSelectedItems);
  }, [selectedItems, onSelectionChange]);
  const filterItemElements = (0, _react.useMemo)(() => {
    return items.map((item, index) => {
      const itemLabel = renderLabel(item);
      const itemElement = renderItem(item);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
        "data-test-subj": `${dataTestSubj}-item`,
        title: itemLabel,
        key: `${index}-${itemLabel}`,
        checked: selectedItems.includes(item) ? 'on' : undefined,
        onClick: () => handleItemClick(item)
      }, itemElement);
    });
  }, [dataTestSubj, items, selectedItems, renderItem, renderLabel, handleItemClick]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": `${dataTestSubj}-popover`,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": `${dataTestSubj}-popoverButton`,
      iconType: "arrowDown",
      grow: false,
      numFilters: items.length,
      numActiveFilters: selectedItems.length,
      hasActiveFilters: selectedItems.length > 0,
      isSelected: isPopoverOpen,
      onClick: togglePopover
    }, title),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, filterItemElements));
};

// We have to wrap it in a function and cast to original type because React.memo
// returns a component type which is not generic.
const enhanceMultiselectFilterComponent = () => {
  const Component = /*#__PURE__*/_react.default.memo(MultiselectFilterComponent);
  Component.displayName = 'MultiselectFilter';
  return Component;
};
const MultiselectFilter = enhanceMultiselectFilterComponent();
exports.MultiselectFilter = MultiselectFilter;
const initializeProps = props => {
  var _props$onSelectionCha, _props$renderLabel, _props$renderItem, _props$dataTestSubj;
  const onSelectionChange = (_props$onSelectionCha = props.onSelectionChange) !== null && _props$onSelectionCha !== void 0 ? _props$onSelectionCha : _lodash.noop;
  const renderLabel = (_props$renderLabel = props.renderLabel) !== null && _props$renderLabel !== void 0 ? _props$renderLabel : String;
  const renderItem = (_props$renderItem = props.renderItem) !== null && _props$renderItem !== void 0 ? _props$renderItem : renderLabel;
  return {
    dataTestSubj: (_props$dataTestSubj = props.dataTestSubj) !== null && _props$dataTestSubj !== void 0 ? _props$dataTestSubj : 'multiselectFilter',
    title: props.title,
    items: props.items,
    selectedItems: props.selectedItems,
    onSelectionChange,
    renderLabel,
    renderItem
  };
};