"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuperHeader = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _react = _interopRequireWildcard(require("react"));
var _helpers = require("../../../../assistant/helpers");
var _header_page = require("../../../../common/components/header_page");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _rules_table_context = require("../../components/rules_table/rules_table/rules_table_context");
var i18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SuperHeader = /*#__PURE__*/_react.default.memo(({
  children
}) => {
  const isAssistantEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('assistantEnabled');
  const memoizedChildren = (0, _react.useMemo)(() => children, [children]);
  // Rules state
  const {
    state: {
      rules,
      selectedRuleIds
    }
  } = (0, _rules_table_context.useRulesTableContext)();
  const selectedRules = (0, _react.useMemo)(() => rules.filter(rule => selectedRuleIds.includes(rule.id)), [rules, selectedRuleIds]);
  const getPromptContext = (0, _react.useCallback)(async () => (0, _helpers.getPromptContextFromDetectionRules)(selectedRules), [selectedRules]);
  return /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    title: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.PAGE_TITLE, ' ', isAssistantEnabled && selectedRules.length > 0 && /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChat, {
      category: "detection-rules",
      conversationId: i18n.DETECTION_RULES_CONVERSATION_ID,
      description: i18n.RULE_MANAGEMENT_CONTEXT_DESCRIPTION,
      getPromptContext: getPromptContext,
      iconType: null,
      suggestedUserPrompt: i18n.EXPLAIN_THEN_SUMMARIZE_RULE_DETAILS,
      tooltip: i18n.RULE_MANAGEMENT_CONTEXT_TOOLTIP
    }, '🪄✨'))
  }, memoizedChildren);
});
exports.SuperHeader = SuperHeader;
SuperHeader.displayName = 'NewChatComponent';