"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTableToolbar = exports.AllRulesTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _tab_navigation_with_breadcrumbs = require("../../../../common/components/navigation/tab_navigation_with_breadcrumbs");
var i18n = _interopRequireWildcard(require("../../../../detections/pages/detection_engine/rules/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AllRulesTabs;
exports.AllRulesTabs = AllRulesTabs;
(function (AllRulesTabs) {
  AllRulesTabs["management"] = "management";
  AllRulesTabs["monitoring"] = "monitoring";
})(AllRulesTabs || (exports.AllRulesTabs = AllRulesTabs = {}));
const RulesTableToolbar = /*#__PURE__*/_react.default.memo(() => {
  const ruleTabs = (0, _react.useMemo)(() => ({
    [AllRulesTabs.management]: {
      id: AllRulesTabs.management,
      name: i18n.RULES_TAB,
      disabled: false,
      href: `/rules/${AllRulesTabs.management}`
    },
    [AllRulesTabs.monitoring]: {
      id: AllRulesTabs.monitoring,
      name: i18n.MONITORING_TAB,
      disabled: false,
      href: `/rules/${AllRulesTabs.monitoring}`
    }
  }), []);
  return /*#__PURE__*/_react.default.createElement(_tab_navigation_with_breadcrumbs.TabNavigationWithBreadcrumbs, {
    navTabs: ruleTabs
  });
});
exports.RulesTableToolbar = RulesTableToolbar;
RulesTableToolbar.displayName = 'RulesTableToolbar';