"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTableUrlSavedPagination = exports.RulesTableStorageSavedPagination = exports.RulesTableSavedSorting = exports.RulesTableSavedFilter = exports.RuleSource = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _logic = require("../../../../rule_management/logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let RuleSource;
exports.RuleSource = RuleSource;
(function (RuleSource) {
  RuleSource["Prebuilt"] = "prebuilt";
  RuleSource["Custom"] = "custom";
})(RuleSource || (exports.RuleSource = RuleSource = {}));
const RulesTableSavedFilter = t.partial({
  searchTerm: t.string,
  source: (0, _securitysolutionIoTsTypes.enumeration)('RuleSource', RuleSource),
  tags: t.array(t.string),
  enabled: t.boolean
});
exports.RulesTableSavedFilter = RulesTableSavedFilter;
const RulesTableSavedSorting = t.partial({
  field: _logic.SortingOptions.props.field,
  order: _logic.SortingOptions.props.order
});
exports.RulesTableSavedSorting = RulesTableSavedSorting;
const RulesTableStorageSavedPagination = t.partial({
  perPage: _logic.PaginationOptions.props.perPage
});
exports.RulesTableStorageSavedPagination = RulesTableStorageSavedPagination;
const RulesTableUrlSavedPagination = t.partial({
  page: _logic.PaginationOptions.props.page,
  perPage: _logic.PaginationOptions.props.perPage
});
exports.RulesTableUrlSavedPagination = RulesTableUrlSavedPagination;