"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRulesTableContextOptional = exports.useRulesTableContext = exports.RulesTableContextProvider = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_fetch_rules_snooze_settings = require("../../../../rule_management/api/hooks/use_fetch_rules_snooze_settings");
var _constants = require("../../../../../../common/constants");
var _invariant = require("../../../../../../common/utils/invariant");
var _use_url_state = require("../../../../../common/hooks/use_url_state");
var _kibana = require("../../../../../common/lib/kibana");
var _helpers = require("../../../../../common/utils/global_query_string/helpers");
var _use_find_rules = require("../../../../rule_management/logic/use_find_rules");
var _constants2 = require("../constants");
var _rules_table_defaults = require("./rules_table_defaults");
var _rules_table_saved_state = require("./rules_table_saved_state");
var _use_rules_table_saved_state = require("./use_rules_table_saved_state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesTableContext = /*#__PURE__*/(0, _react.createContext)(null);
const RulesTableContextProvider = ({
  children
}) => {
  var _savedFilter$searchTe, _savedFilter$tags, _ref, _ref2, _savedSorting$field, _savedSorting$order, _savedPagination$page, _savedPagination$perP;
  const [autoRefreshSettings] = (0, _kibana.useUiSetting$)(_constants.DEFAULT_RULES_TABLE_REFRESH_SETTING);
  const {
    sessionStorage
  } = (0, _kibana.useKibana)().services;
  const {
    filter: savedFilter,
    sorting: savedSorting,
    pagination: savedPagination
  } = (0, _use_rules_table_saved_state.useRulesTableSavedState)();
  const [filterOptions, setFilterOptions] = (0, _react.useState)({
    filter: (_savedFilter$searchTe = savedFilter === null || savedFilter === void 0 ? void 0 : savedFilter.searchTerm) !== null && _savedFilter$searchTe !== void 0 ? _savedFilter$searchTe : _rules_table_defaults.DEFAULT_FILTER_OPTIONS.filter,
    tags: (_savedFilter$tags = savedFilter === null || savedFilter === void 0 ? void 0 : savedFilter.tags) !== null && _savedFilter$tags !== void 0 ? _savedFilter$tags : _rules_table_defaults.DEFAULT_FILTER_OPTIONS.tags,
    showCustomRules: (_ref = (savedFilter === null || savedFilter === void 0 ? void 0 : savedFilter.source) === _rules_table_saved_state.RuleSource.Custom) !== null && _ref !== void 0 ? _ref : _rules_table_defaults.DEFAULT_FILTER_OPTIONS.showCustomRules,
    showElasticRules: (_ref2 = (savedFilter === null || savedFilter === void 0 ? void 0 : savedFilter.source) === _rules_table_saved_state.RuleSource.Prebuilt) !== null && _ref2 !== void 0 ? _ref2 : _rules_table_defaults.DEFAULT_FILTER_OPTIONS.showElasticRules,
    enabled: savedFilter === null || savedFilter === void 0 ? void 0 : savedFilter.enabled
  });
  const [sortingOptions, setSortingOptions] = (0, _react.useState)({
    field: (_savedSorting$field = savedSorting === null || savedSorting === void 0 ? void 0 : savedSorting.field) !== null && _savedSorting$field !== void 0 ? _savedSorting$field : _rules_table_defaults.DEFAULT_SORTING_OPTIONS.field,
    order: (_savedSorting$order = savedSorting === null || savedSorting === void 0 ? void 0 : savedSorting.order) !== null && _savedSorting$order !== void 0 ? _savedSorting$order : _rules_table_defaults.DEFAULT_SORTING_OPTIONS.order
  });
  const [isAllSelected, setIsAllSelected] = (0, _react.useState)(false);
  const [isRefreshOn, setIsRefreshOn] = (0, _react.useState)(autoRefreshSettings.on);
  const [loadingRules, setLoadingRules] = (0, _react.useState)({
    ids: [],
    action: null
  });
  const [isPreflightInProgress, setIsPreflightInProgress] = (0, _react.useState)(false);
  const [page, setPage] = (0, _react.useState)((_savedPagination$page = savedPagination === null || savedPagination === void 0 ? void 0 : savedPagination.page) !== null && _savedPagination$page !== void 0 ? _savedPagination$page : _rules_table_defaults.DEFAULT_PAGE);
  const [perPage, setPerPage] = (0, _react.useState)((_savedPagination$perP = savedPagination === null || savedPagination === void 0 ? void 0 : savedPagination.perPage) !== null && _savedPagination$perP !== void 0 ? _savedPagination$perP : _rules_table_defaults.DEFAULT_RULES_PER_PAGE);
  const [selectedRuleIds, setSelectedRuleIds] = (0, _react.useState)([]);
  const autoRefreshBeforePause = (0, _react.useRef)(null);
  const isActionInProgress = loadingRules.ids.length > 0;
  const pagination = (0, _react.useMemo)(() => ({
    page,
    perPage
  }), [page, perPage]);
  const handleFilterOptionsChange = (0, _react.useCallback)(newFilter => {
    setFilterOptions(currentFilter => ({
      ...currentFilter,
      ...newFilter
    }));
    setPage(1);
    setSelectedRuleIds([]);
    setIsAllSelected(false);
  }, []);
  const clearRulesSelection = (0, _react.useCallback)(() => {
    setSelectedRuleIds([]);
    setIsAllSelected(false);
  }, []);
  const replaceUrlParams = (0, _helpers.useReplaceUrlParams)();
  const clearFilters = (0, _react.useCallback)(() => {
    setFilterOptions({
      filter: _rules_table_defaults.DEFAULT_FILTER_OPTIONS.filter,
      showElasticRules: _rules_table_defaults.DEFAULT_FILTER_OPTIONS.showElasticRules,
      showCustomRules: _rules_table_defaults.DEFAULT_FILTER_OPTIONS.showCustomRules,
      tags: _rules_table_defaults.DEFAULT_FILTER_OPTIONS.tags,
      enabled: undefined
    });
    setSortingOptions({
      field: _rules_table_defaults.DEFAULT_SORTING_OPTIONS.field,
      order: _rules_table_defaults.DEFAULT_SORTING_OPTIONS.order
    });
    setPage(_rules_table_defaults.DEFAULT_PAGE);
    setPerPage(_rules_table_defaults.DEFAULT_RULES_PER_PAGE);
    replaceUrlParams({
      [_use_url_state.URL_PARAM_KEY.rulesTable]: null
    });
    sessionStorage.remove(_constants2.RULES_TABLE_STATE_STORAGE_KEY);
  }, [setFilterOptions, setSortingOptions, setPage, setPerPage, replaceUrlParams, sessionStorage]);
  (0, _react.useEffect)(() => {
    // pause table auto refresh when any of rule selected
    // store current auto refresh value, to use it later, when all rules selection will be cleared
    if (selectedRuleIds.length > 0) {
      setIsRefreshOn(false);
      if (autoRefreshBeforePause.current == null) {
        autoRefreshBeforePause.current = isRefreshOn;
      }
    } else {
      var _autoRefreshBeforePau;
      // if no rules selected, update auto refresh value, with previously stored value
      setIsRefreshOn((_autoRefreshBeforePau = autoRefreshBeforePause.current) !== null && _autoRefreshBeforePau !== void 0 ? _autoRefreshBeforePau : isRefreshOn);
      autoRefreshBeforePause.current = null;
    }
  }, [selectedRuleIds, isRefreshOn]);

  // Fetch rules
  const {
    data: {
      rules,
      total
    } = {
      rules: [],
      total: 0
    },
    refetch,
    dataUpdatedAt,
    isFetched,
    isFetching,
    isLoading,
    isRefetching
  } = (0, _use_find_rules.useFindRules)({
    filterOptions,
    sortingOptions,
    pagination
  }, {
    refetchInterval: isRefreshOn && !isActionInProgress && autoRefreshSettings.value,
    keepPreviousData: true // Use this option so that the state doesn't jump between "success" and "loading" on page change
  });

  // Fetch rules snooze settings
  const {
    data: rulesSnoozeSettingsMap,
    isLoading: isSnoozeSettingsLoading,
    isFetching: isSnoozeSettingsFetching,
    isError: isSnoozeSettingsFetchError,
    refetch: refetchSnoozeSettings
  } = (0, _use_fetch_rules_snooze_settings.useFetchRulesSnoozeSettings)(rules.map(x => x.id), {
    enabled: rules.length > 0
  });
  const refetchRulesAndSnoozeSettings = (0, _react.useCallback)(async () => {
    const response = await refetch();
    await refetchSnoozeSettings();
    return response;
  }, [refetch, refetchSnoozeSettings]);
  const actions = (0, _react.useMemo)(() => ({
    reFetchRules: refetchRulesAndSnoozeSettings,
    setFilterOptions: handleFilterOptionsChange,
    setIsAllSelected,
    setIsRefreshOn,
    setLoadingRules,
    setPage,
    setPerPage,
    setSelectedRuleIds,
    setSortingOptions,
    clearRulesSelection,
    setIsPreflightInProgress,
    clearFilters
  }), [refetchRulesAndSnoozeSettings, handleFilterOptionsChange, setIsAllSelected, setIsRefreshOn, setLoadingRules, setPage, setPerPage, setSelectedRuleIds, setSortingOptions, clearRulesSelection, setIsPreflightInProgress, clearFilters]);
  const providerValue = (0, _react.useMemo)(() => ({
    state: {
      rules,
      rulesSnoozeSettings: {
        data: rulesSnoozeSettingsMap !== null && rulesSnoozeSettingsMap !== void 0 ? rulesSnoozeSettingsMap : {},
        isLoading: isSnoozeSettingsLoading,
        isFetching: isSnoozeSettingsFetching,
        isError: isSnoozeSettingsFetchError
      },
      pagination: {
        page,
        perPage,
        total
      },
      filterOptions,
      isPreflightInProgress,
      isActionInProgress,
      isAllSelected,
      isFetched,
      isFetching,
      isLoading,
      isRefetching,
      isRefreshOn,
      lastUpdated: dataUpdatedAt,
      loadingRuleIds: loadingRules.ids,
      loadingRulesAction: loadingRules.action,
      selectedRuleIds,
      sortingOptions,
      isDefault: isDefaultState(filterOptions, sortingOptions, {
        page,
        perPage,
        total
      })
    },
    actions
  }), [rules, rulesSnoozeSettingsMap, isSnoozeSettingsLoading, isSnoozeSettingsFetching, isSnoozeSettingsFetchError, page, perPage, total, filterOptions, isPreflightInProgress, isActionInProgress, isAllSelected, isFetched, isFetching, isLoading, isRefetching, isRefreshOn, dataUpdatedAt, loadingRules.ids, loadingRules.action, selectedRuleIds, sortingOptions, actions]);
  return /*#__PURE__*/_react.default.createElement(RulesTableContext.Provider, {
    value: providerValue
  }, children);
};
exports.RulesTableContextProvider = RulesTableContextProvider;
const useRulesTableContext = () => {
  const rulesTableContext = (0, _react.useContext)(RulesTableContext);
  (0, _invariant.invariant)(rulesTableContext, 'useRulesTableContext should be used inside RulesTableContextProvider');
  return rulesTableContext;
};
exports.useRulesTableContext = useRulesTableContext;
const useRulesTableContextOptional = () => (0, _react.useContext)(RulesTableContext);
exports.useRulesTableContextOptional = useRulesTableContextOptional;
function isDefaultState(filter, sorting, pagination) {
  return (0, _lodash.isEqual)(filter, _rules_table_defaults.DEFAULT_FILTER_OPTIONS) && (0, _lodash.isEqual)(sorting, _rules_table_defaults.DEFAULT_SORTING_OPTIONS) && pagination.page === _rules_table_defaults.DEFAULT_PAGE && pagination.perPage === _rules_table_defaults.DEFAULT_RULES_PER_PAGE;
}