"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formSchema = exports.ScheduleForm = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _request_schema = require("../../../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _schedule_item_form = require("../../../../../../detections/components/rules/schedule_item_form");
var _shared_imports = require("../../../../../../shared_imports");
var _translations = require("../translations");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formSchema = {
  interval: {
    label: _translations.bulkSetSchedule.INTERVAL_LABEL,
    helpText: _translations.bulkSetSchedule.INTERVAL_HELP_TEXT
  },
  lookback: {
    label: _translations.bulkSetSchedule.LOOKBACK_LABEL,
    helpText: _translations.bulkSetSchedule.LOOKBACK_HELP_TEXT
  }
};
exports.formSchema = formSchema;
const defaultFormData = {
  interval: '5m',
  lookback: '1m'
};
const ScheduleForm = ({
  rulesCount,
  onClose,
  onConfirm
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema: formSchema,
    defaultValue: defaultFormData
  });
  const handleSubmit = (0, _react.useCallback)(async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    onConfirm({
      type: _request_schema.BulkActionEditType.set_schedule,
      value: {
        interval: data.interval,
        lookback: data.lookback
      }
    });
  }, [form, onConfirm]);
  const warningCallout = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    "data-test-subj": "bulkEditRulesSchedulesWarning"
  }, _translations.bulkSetSchedule.warningCalloutMessage(rulesCount));
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    title: _translations.bulkSetSchedule.FORM_TITLE,
    banner: warningCallout,
    onClose: onClose,
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "interval",
    component: _schedule_item_form.ScheduleItem,
    componentProps: {
      idAria: 'bulkEditRulesScheduleIntervalSelector',
      dataTestSubj: 'bulkEditRulesScheduleIntervalSelector',
      fullWidth: true,
      minimumValue: 1
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "lookback",
    component: _schedule_item_form.ScheduleItem,
    componentProps: {
      idAria: 'bulkEditRulesScheduleLookbackSelector',
      dataTestSubj: 'bulkEditRulesScheduleLookbackSelector',
      fullWidth: true,
      minimumValue: 1
    }
  }));
};
exports.ScheduleForm = ScheduleForm;