"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternsForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("../../../../../../detections/pages/detection_engine/rules/translations"));
var _constants = require("../../../../../../../common/constants");
var _kibana = require("../../../../../../common/lib/kibana");
var _request_schema = require("../../../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _shared_imports = require("../../../../../../shared_imports");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const schema = {
  index: {
    fieldsToValidateOnChange: ['index'],
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(i18n.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_REQUIRED_ERROR)
    }]
  },
  overwrite: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_OVERWRITE_LABEL
  },
  overwriteDataViews: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: i18n.BULK_EDIT_FLYOUT_FORM_DATA_VIEWS_OVERWRITE_LABEL
  }
};
const initialFormData = {
  index: [],
  overwrite: false,
  overwriteDataViews: false
};
const getFormConfig = editAction => editAction === _request_schema.BulkActionEditType.add_index_patterns ? {
  indexLabel: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_LABEL,
  indexHelpText: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_HELP_TEXT,
  formTitle: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_TITLE
} : {
  indexLabel: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_LABEL,
  indexHelpText: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_HELP_TEXT,
  formTitle: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_TITLE
};
const IndexPatternsFormComponent = ({
  editAction,
  rulesCount,
  onClose,
  onConfirm
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialFormData,
    schema
  });
  const {
    indexHelpText,
    indexLabel,
    formTitle
  } = getFormConfig(editAction);
  const [{
    overwrite,
    overwriteDataViews
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['overwrite', 'overwriteDataViews']
  });
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const defaultPatterns = uiSettings.get(_constants.DEFAULT_INDEX_KEY);
  const handleSubmit = async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    const payload = {
      value: data.index,
      type: data.overwrite ? _request_schema.BulkActionEditType.set_index_patterns : editAction,
      overwrite_data_views: data.overwriteDataViews
    };
    onConfirm(payload);
  };
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    onClose: onClose,
    onSubmit: handleSubmit,
    title: formTitle
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "index",
    config: {
      ...schema.index,
      label: indexLabel,
      helpText: indexHelpText
    },
    componentProps: {
      idAria: 'bulkEditRulesIndexPatterns',
      'data-test-subj': 'bulkEditRulesIndexPatterns',
      euiFieldProps: {
        fullWidth: true,
        placeholder: '',
        noSuggestions: false,
        options: defaultPatterns.map(label => ({
          label
        }))
      }
    }
  }), editAction === _request_schema.BulkActionEditType.add_index_patterns && /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "overwrite",
    componentProps: {
      idAria: 'bulkEditRulesOverwriteIndexPatterns',
      'data-test-subj': 'bulkEditRulesOverwriteIndexPatterns'
    }
  }), overwrite && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    "data-test-subj": "bulkEditRulesIndexPatternsWarning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.setIndexPatternsWarningCallout",
    defaultMessage: "You\u2019re about to overwrite index patterns for {rulesCount, plural, one {# selected rule} other {# selected rules}}, press Save to apply changes.",
    values: {
      rulesCount
    }
  }))), editAction === _request_schema.BulkActionEditType.add_index_patterns && /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "overwriteDataViews",
    componentProps: {
      idAria: 'bulkEditRulesOverwriteRulesWithDataViews',
      'data-test-subj': 'bulkEditRulesOverwriteRulesWithDataViews'
    }
  }), overwriteDataViews && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    "data-test-subj": "bulkEditRulesDataViewsWarning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.setDataViewsOverwriteWarningCallout",
    defaultMessage: "If you have selected rules which depend on a data view this action will force those rules to read from the index pattern as defined after this update, not the dataview, and may result in broken rules."
  }))), editAction === _request_schema.BulkActionEditType.delete_index_patterns && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    "data-test-subj": "bulkEditRulesDataViewsWarning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.deleteIndexPattnersDataViewsOverwriteWarningCallout",
    defaultMessage: "If you have selected rules which depend on a data view this action will not have any effect on those rules."
  }))));
};
const IndexPatternsForm = /*#__PURE__*/_react.default.memo(IndexPatternsFormComponent);
exports.IndexPatternsForm = IndexPatternsForm;
IndexPatternsForm.displayName = 'IndexPatternsForm';