"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkEditFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _request_schema = require("../../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _index_patterns_form = require("./forms/index_patterns_form");
var _tags_form = require("./forms/tags_form");
var _timeline_template_form = require("./forms/timeline_template_form");
var _rule_actions_form = require("./forms/rule_actions_form");
var _schedule_form = require("./forms/schedule_form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkEditFlyoutComponent = ({
  editAction,
  ...props
}) => {
  switch (editAction) {
    case _request_schema.BulkActionEditType.add_index_patterns:
    case _request_schema.BulkActionEditType.delete_index_patterns:
    case _request_schema.BulkActionEditType.set_index_patterns:
      return /*#__PURE__*/_react.default.createElement(_index_patterns_form.IndexPatternsForm, (0, _extends2.default)({}, props, {
        editAction: editAction
      }));
    case _request_schema.BulkActionEditType.add_tags:
    case _request_schema.BulkActionEditType.delete_tags:
    case _request_schema.BulkActionEditType.set_tags:
      return /*#__PURE__*/_react.default.createElement(_tags_form.TagsForm, (0, _extends2.default)({}, props, {
        editAction: editAction
      }));
    case _request_schema.BulkActionEditType.set_timeline:
      return /*#__PURE__*/_react.default.createElement(_timeline_template_form.TimelineTemplateForm, props);
    case _request_schema.BulkActionEditType.add_rule_actions:
    case _request_schema.BulkActionEditType.set_rule_actions:
      return /*#__PURE__*/_react.default.createElement(_rule_actions_form.RuleActionsForm, props);
    case _request_schema.BulkActionEditType.set_schedule:
      return /*#__PURE__*/_react.default.createElement(_schedule_form.ScheduleForm, props);
    default:
      return null;
  }
};
const BulkEditFlyout = /*#__PURE__*/_react.default.memo(BulkEditFlyoutComponent);
exports.BulkEditFlyout = BulkEditFlyout;
BulkEditFlyout.displayName = 'BulkEditFlyout';