"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActionDryRunConfirmation = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../../../../detections/pages/detection_engine/rules/translations"));
var _bulk_action_rule_errors_list = require("./bulk_action_rule_errors_list");
var _request_schema = require("../../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _utility_types = require("../../../../../../common/utility_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActionRejectedTitle = (bulkAction, failedRulesCount) => {
  switch (bulkAction) {
    case _request_schema.BulkActionType.edit:
      return i18n.BULK_EDIT_CONFIRMATION_REJECTED_TITLE(failedRulesCount);
    case _request_schema.BulkActionType.export:
      return i18n.BULK_EXPORT_CONFIRMATION_REJECTED_TITLE(failedRulesCount);
    default:
      (0, _utility_types.assertUnreachable)(bulkAction);
  }
};
const getActionConfirmLabel = (bulkAction, succeededRulesCount) => {
  switch (bulkAction) {
    case _request_schema.BulkActionType.edit:
      return i18n.BULK_EDIT_CONFIRMATION_CONFIRM(succeededRulesCount);
    case _request_schema.BulkActionType.export:
      return i18n.BULK_EXPORT_CONFIRMATION_CONFIRM(succeededRulesCount);
    default:
      (0, _utility_types.assertUnreachable)(bulkAction);
  }
};
const BulkActionDryRunConfirmationComponent = ({
  onCancel,
  onConfirm,
  result,
  bulkAction
}) => {
  const {
    failedRulesCount = 0,
    succeededRulesCount = 0,
    ruleErrors = []
  } = result !== null && result !== void 0 ? result : {};

  // if no rule can be edited, modal window that denies bulk edit action will be displayed
  if (succeededRulesCount === 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      title: getActionRejectedTitle(bulkAction, failedRulesCount),
      onCancel: onCancel,
      onConfirm: onCancel,
      confirmButtonText: i18n.BULK_ACTION_CONFIRMATION_CLOSE,
      defaultFocusedButton: "confirm",
      "data-test-subj": "bulkActionRejectModal"
    }, /*#__PURE__*/_react.default.createElement(_bulk_action_rule_errors_list.BulkActionRuleErrorsList, {
      bulkAction: bulkAction,
      ruleErrors: ruleErrors
    }));
  }

  // if there are rules that can and cannot be edited, modal window that propose edit of some the rules will be displayed
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: i18n.BULK_ACTION_CONFIRMATION_PARTLY_TITLE(succeededRulesCount),
    onCancel: onCancel,
    onConfirm: onConfirm,
    confirmButtonText: getActionConfirmLabel(bulkAction, succeededRulesCount),
    cancelButtonText: i18n.BULK_EDIT_CONFIRMATION_CANCEL,
    defaultFocusedButton: "confirm",
    "data-test-subj": "bulkActionConfirmationModal"
  }, /*#__PURE__*/_react.default.createElement(_bulk_action_rule_errors_list.BulkActionRuleErrorsList, {
    bulkAction: bulkAction,
    ruleErrors: ruleErrors
  }));
};
const BulkActionDryRunConfirmation = /*#__PURE__*/_react.default.memo(BulkActionDryRunConfirmationComponent);
exports.BulkActionDryRunConfirmation = BulkActionDryRunConfirmation;
BulkActionDryRunConfirmation.displayName = 'BulkActionDryRunConfirmation';