"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrePackagedTimelinesInstallationStatus = void 0;
var _helpers = require("../../../detections/pages/detection_engine/rules/helpers");
var _use_pre_packaged_rules_status = require("./use_pre_packaged_rules_status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePrePackagedTimelinesInstallationStatus = () => {
  const {
    data: prePackagedRulesStatus
  } = (0, _use_pre_packaged_rules_status.usePrePackagedRulesStatus)();
  return (0, _helpers.getPrePackagedTimelineInstallationStatus)(prePackagedRulesStatus === null || prePackagedRulesStatus === void 0 ? void 0 : prePackagedRulesStatus.timelines_installed, prePackagedRulesStatus === null || prePackagedRulesStatus === void 0 ? void 0 : prePackagedRulesStatus.timelines_not_installed, prePackagedRulesStatus === null || prePackagedRulesStatus === void 0 ? void 0 : prePackagedRulesStatus.timelines_not_updated);
};
exports.usePrePackagedTimelinesInstallationStatus = usePrePackagedTimelinesInstallationStatus;