"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePrePackagedRulesStatus = void 0;
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _use_fetch_prebuilt_rules_status_query = require("../api/hooks/use_fetch_prebuilt_rules_status_query");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePrePackagedRulesStatus = () => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _use_fetch_prebuilt_rules_status_query.useFetchPrebuiltRulesStatusQuery)({
    onError: err => {
      addError(err, {
        title: i18n.RULE_AND_TIMELINE_FETCH_FAILURE
      });
    }
  });
};
exports.usePrePackagedRulesStatus = usePrePackagedRulesStatus;