"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsInstallingPrePackagedRules = exports.useInstallPrePackagedRules = void 0;
var _reactQuery = require("@tanstack/react-query");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _use_create_prebuilt_rules_mutation = require("../api/hooks/use_create_prebuilt_rules_mutation");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useInstallPrePackagedRules = () => {
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _use_create_prebuilt_rules_mutation.useCreatePrebuiltRulesMutation)({
    onError: err => {
      addError(err, {
        title: i18n.RULE_AND_TIMELINE_PREPACKAGED_FAILURE
      });
    },
    onSuccess: result => {
      addSuccess(getSuccessToastMessage(result));
    }
  });
};
exports.useInstallPrePackagedRules = useInstallPrePackagedRules;
const useIsInstallingPrePackagedRules = () => {
  const mutationsCount = (0, _reactQuery.useIsMutating)(_use_create_prebuilt_rules_mutation.CREATE_PREBUILT_RULES_MUTATION_KEY);
  return mutationsCount > 0;
};
exports.useIsInstallingPrePackagedRules = useIsInstallingPrePackagedRules;
const getSuccessToastMessage = result => {
  const {
    rules_installed: rulesInstalled,
    rules_updated: rulesUpdated,
    timelines_installed: timelinesInstalled,
    timelines_updated: timelinesUpdated
  } = result;
  if (rulesInstalled === 0 && (timelinesInstalled > 0 || timelinesUpdated > 0)) {
    return i18n.TIMELINE_PREPACKAGED_SUCCESS;
  } else if ((rulesInstalled > 0 || rulesUpdated > 0) && timelinesInstalled === 0) {
    return i18n.RULE_PREPACKAGED_SUCCESS;
  } else {
    return i18n.RULE_AND_TIMELINE_PREPACKAGED_SUCCESS;
  }
};