"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useCreatePrePackagedRules = void 0;
var _react = require("react");
var _user_info = require("../../../detections/components/user_info");
var _use_install_pre_packaged_rules = require("./use_install_pre_packaged_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useCreatePrePackagedRules = () => {
  const [{
    isSignalIndexExists,
    isAuthenticated,
    hasEncryptionKey,
    canUserCRUD,
    hasIndexWrite
  }] = (0, _user_info.useUserData)();
  const {
    mutateAsync: installPrePackagedRules,
    isLoading
  } = (0, _use_install_pre_packaged_rules.useInstallPrePackagedRules)();
  const canCreatePrePackagedRules = canUserCRUD && hasIndexWrite && isAuthenticated && hasEncryptionKey && isSignalIndexExists;
  const createPrePackagedRules = (0, _react.useCallback)(async () => {
    if (canCreatePrePackagedRules) {
      await installPrePackagedRules();
    }
  }, [canCreatePrePackagedRules, installPrePackagedRules]);
  return {
    isLoading,
    createPrePackagedRules,
    canCreatePrePackagedRules
  };
};
exports.useCreatePrePackagedRules = useCreatePrePackagedRules;