"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.action = exports.SortingOptions = exports.RulesSchema = exports.RuleSchema = exports.PaginationOptions = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _securitysolutionIoTsAlertingTypes = require("@kbn/securitysolution-io-ts-alerting-types");
var _securitysolutionIoTsTypes = require("@kbn/securitysolution-io-ts-types");
var _rule_monitoring = require("../../../../common/detection_engine/rule_monitoring");
var _rule_schema = require("../../../../common/detection_engine/rule_schema");
var _rule_management = require("../../../../common/detection_engine/rule_management");
var _common = require("../../../../common/detection_engine/schemas/common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Params is an "record", since it is a type of RuleActionParams which is action templates.
 * @see x-pack/plugins/alerting/common/rule.ts
 * @deprecated Use the one from @kbn/security-io-ts-alerting-types
 */
const action = t.exact(t.type({
  group: t.string,
  id: t.string,
  action_type_id: t.string,
  params: t.record(t.string, t.any)
}));
exports.action = action;
const MetaRule = t.intersection([t.type({
  from: t.string
}), t.partial({
  throttle: t.string,
  kibana_siem_app_url: t.string
})]);
const RuleSchema = t.intersection([t.type({
  author: _rule_schema.RuleAuthorArray,
  created_at: t.string,
  created_by: t.string,
  description: _rule_schema.RuleDescription,
  enabled: _rule_schema.IsRuleEnabled,
  false_positives: _rule_schema.RuleFalsePositiveArray,
  from: _securitysolutionIoTsAlertingTypes.RuleIntervalFrom,
  id: _rule_schema.RuleObjectId,
  interval: _securitysolutionIoTsAlertingTypes.RuleInterval,
  immutable: _rule_schema.IsRuleImmutable,
  name: _rule_schema.RuleName,
  max_signals: _rule_schema.MaxSignals,
  references: _rule_schema.RuleReferenceArray,
  related_integrations: _rule_schema.RelatedIntegrationArray,
  required_fields: _rule_schema.RequiredFieldArray,
  risk_score: _securitysolutionIoTsAlertingTypes.RiskScore,
  risk_score_mapping: _securitysolutionIoTsAlertingTypes.RiskScoreMapping,
  rule_id: _rule_schema.RuleSignatureId,
  severity: _securitysolutionIoTsAlertingTypes.Severity,
  severity_mapping: _securitysolutionIoTsAlertingTypes.SeverityMapping,
  setup: _rule_schema.SetupGuide,
  tags: _rule_schema.RuleTagArray,
  type: _securitysolutionIoTsAlertingTypes.type,
  to: _securitysolutionIoTsAlertingTypes.RuleIntervalTo,
  threat: _rule_schema.ThreatArray,
  updated_at: t.string,
  updated_by: t.string,
  actions: _securitysolutionIoTsAlertingTypes.RuleActionArray,
  throttle: t.union([_securitysolutionIoTsAlertingTypes.RuleActionThrottle, t.null])
}), t.partial({
  outcome: _rule_schema.SavedObjectResolveOutcome,
  alias_target_id: _rule_schema.SavedObjectResolveAliasTargetId,
  alias_purpose: _rule_schema.SavedObjectResolveAliasPurpose,
  building_block_type: _rule_schema.BuildingBlockType,
  anomaly_threshold: t.number,
  filters: _rule_schema.RuleFilterArray,
  index: _rule_schema.IndexPatternArray,
  data_view_id: _rule_schema.DataViewId,
  language: t.string,
  license: _rule_schema.RuleLicense,
  meta: MetaRule,
  machine_learning_job_id: t.array(t.string),
  new_terms_fields: t.array(t.string),
  history_window_start: t.string,
  output_index: _rule_schema.AlertsIndex,
  query: _rule_schema.RuleQuery,
  rule_name_override: _rule_schema.RuleNameOverride,
  saved_id: t.string,
  threshold: _rule_schema.Threshold,
  threat_query: _securitysolutionIoTsAlertingTypes.threat_query,
  threat_filters: _securitysolutionIoTsAlertingTypes.threat_filters,
  threat_index: _securitysolutionIoTsAlertingTypes.threat_index,
  threat_indicator_path: _securitysolutionIoTsAlertingTypes.threat_indicator_path,
  threat_mapping: _securitysolutionIoTsAlertingTypes.threat_mapping,
  threat_language: _securitysolutionIoTsAlertingTypes.threat_language,
  timeline_id: _rule_schema.TimelineTemplateId,
  timeline_title: _rule_schema.TimelineTemplateTitle,
  timestamp_override: _rule_schema.TimestampOverride,
  timestamp_override_fallback_disabled: _rule_schema.TimestampOverrideFallbackDisabled,
  event_category_override: _rule_schema.EventCategoryOverride,
  timestamp_field: _rule_schema.TimestampField,
  tiebreaker_field: _rule_schema.TiebreakerField,
  note: _rule_schema.InvestigationGuide,
  exceptions_list: _rule_schema.ExceptionListArray,
  uuid: t.string,
  version: _rule_schema.RuleVersion,
  execution_summary: _rule_monitoring.RuleExecutionSummary,
  alert_suppression: _rule_schema.AlertSuppression
})]);
exports.RuleSchema = RuleSchema;
const RulesSchema = t.array(RuleSchema);
exports.RulesSchema = RulesSchema;
const PaginationOptions = t.type({
  page: _securitysolutionIoTsTypes.PositiveInteger,
  perPage: _securitysolutionIoTsTypes.PositiveInteger,
  total: _securitysolutionIoTsTypes.PositiveInteger
});
exports.PaginationOptions = PaginationOptions;
const SortingOptions = t.type({
  field: _rule_management.FindRulesSortField,
  order: _common.SortOrder
});
exports.SortingOptions = SortingOptions;