"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShowBulkErrorToast = useShowBulkErrorToast;
var _react = require("react");
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useShowBulkErrorToast() {
  const toasts = (0, _use_app_toasts.useAppToasts)();
  return (0, _react.useCallback)(({
    actionType,
    error
  }) => {
    toasts.addError(populateErrorStack(error), {
      title: (0, _translations.summarizeBulkError)(actionType),
      toastMessage: (0, _translations.explainBulkError)(actionType, error)
    });
  }, [toasts]);
}
function populateErrorStack(error) {
  error.stack = JSON.stringify(error.body, null, 2);
  return error;
}