"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGuessRuleIdsForBulkAction = useGuessRuleIdsForBulkAction;
var _react = require("react");
var _request_schema = require("../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _rules_table_context = require("../../../rule_management_ui/components/rules_table/rules_table/rules_table_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGuessRuleIdsForBulkAction() {
  const rulesTableContext = (0, _rules_table_context.useRulesTableContextOptional)();
  return (0, _react.useCallback)(bulkActionType => {
    const allRules = rulesTableContext !== null && rulesTableContext !== void 0 && rulesTableContext.state.isAllSelected ? rulesTableContext.state.rules : [];
    const processingRules = bulkActionType === _request_schema.BulkActionType.enable ? allRules.filter(x => !x.enabled) : bulkActionType === _request_schema.BulkActionType.disable ? allRules.filter(x => x.enabled) : allRules;
    return processingRules.map(r => r.id);
  }, [rulesTableContext]);
}